/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.multipart.support;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMultipartHttpServletRequest
extends HttpServletRequestWrapper
implements MultipartHttpServletRequest {
    private Map<String, MultipartFile> multipartFiles;

    protected AbstractMultipartHttpServletRequest(HttpServletRequest request) {
        super(request);
    }

    @Override
    public Iterator<String> getFileNames() {
        return this.getMultipartFiles().keySet().iterator();
    }

    @Override
    public MultipartFile getFile(String name) {
        return this.getMultipartFiles().get(name);
    }

    @Override
    public Map<String, MultipartFile> getFileMap() {
        return this.getMultipartFiles();
    }

    protected final void setMultipartFiles(Map<String, MultipartFile> multipartFiles) {
        this.multipartFiles = Collections.unmodifiableMap(multipartFiles);
    }

    protected Map<String, MultipartFile> getMultipartFiles() {
        if (this.multipartFiles == null) {
            this.initializeMultipart();
        }
        return this.multipartFiles;
    }

    protected void initializeMultipart() {
        throw new IllegalStateException("Multipart request not initialized");
    }
}

