/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

public abstract class AbstractClientHttpRequest
implements ClientHttpRequest {
    private boolean executed = false;
    private final HttpHeaders headers = new HttpHeaders();

    public final HttpHeaders getHeaders() {
        return this.executed ? HttpHeaders.readOnlyHttpHeaders(this.headers) : this.headers;
    }

    public final OutputStream getBody() throws IOException {
        this.checkExecuted();
        return this.getBodyInternal(this.headers);
    }

    protected abstract OutputStream getBodyInternal(HttpHeaders var1) throws IOException;

    public final ClientHttpResponse execute() throws IOException {
        this.checkExecuted();
        ClientHttpResponse result = this.executeInternal(this.headers);
        this.executed = true;
        return result;
    }

    private void checkExecuted() {
        Assert.state((!this.executed ? 1 : 0) != 0, (String)"ClientHttpRequest already executed");
    }

    protected abstract ClientHttpResponse executeInternal(HttpHeaders var1) throws IOException;
}

