/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.support;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.context.annotation.ScopeMetadataResolver;
import org.springframework.core.env.Environment;
import org.springframework.web.context.support.AbstractRefreshableWebApplicationContext;

public class AnnotationConfigWebApplicationContext
extends AbstractRefreshableWebApplicationContext {
    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) {
        String[] configLocations;
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
        reader.setEnvironment((Environment)this.getEnvironment());
        ClassPathBeanDefinitionScanner scanner = new ClassPathBeanDefinitionScanner((BeanDefinitionRegistry)beanFactory);
        scanner.setEnvironment((Environment)this.getEnvironment());
        BeanNameGenerator beanNameGenerator = this.getBeanNameGenerator();
        ScopeMetadataResolver scopeMetadataResolver = this.getScopeMetadataResolver();
        if (beanNameGenerator != null) {
            reader.setBeanNameGenerator(beanNameGenerator);
            scanner.setBeanNameGenerator(beanNameGenerator);
        }
        if (scopeMetadataResolver != null) {
            reader.setScopeMetadataResolver(scopeMetadataResolver);
            scanner.setScopeMetadataResolver(scopeMetadataResolver);
        }
        if ((configLocations = this.getConfigLocations()) != null) {
            String[] stringArray = configLocations;
            int n = configLocations.length;
            int n2 = 0;
            while (n2 < n) {
                block9: {
                    String configLocation = stringArray[n2];
                    try {
                        Class<?> clazz = this.getClassLoader().loadClass(configLocation);
                        if (this.logger.isInfoEnabled()) {
                            this.logger.info((Object)("Successfully resolved class for [" + configLocation + "]"));
                        }
                        reader.register(new Class[]{clazz});
                    }
                    catch (ClassNotFoundException ex) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Could not load class for config location [" + configLocation + "] - trying package scan. " + ex));
                        }
                        int count = scanner.scan(new String[]{configLocation});
                        if (!this.logger.isInfoEnabled()) break block9;
                        if (count == 0) {
                            this.logger.info((Object)("No annotated classes found for specified class/package [" + configLocation + "]"));
                        }
                        this.logger.info((Object)("Found " + count + " annotated classes in package [" + configLocation + "]"));
                    }
                }
                ++n2;
            }
        }
    }

    protected BeanNameGenerator getBeanNameGenerator() {
        return null;
    }

    protected ScopeMetadataResolver getScopeMetadataResolver() {
        return null;
    }
}

