/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.WebApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextLoader {
    public static final String CONTEXT_CLASS_PARAM = "contextClass";
    public static final String CONTEXT_INITIALIZER_CLASSES_PARAM = "contextInitializerClasses";
    public static final String CONFIG_LOCATION_PARAM = "contextConfigLocation";
    public static final String LOCATOR_FACTORY_SELECTOR_PARAM = "locatorFactorySelector";
    public static final String LOCATOR_FACTORY_KEY_PARAM = "parentContextKey";
    private static final String DEFAULT_STRATEGIES_PATH = "ContextLoader.properties";
    private static final Properties defaultStrategies;
    private static final Map<ClassLoader, WebApplicationContext> currentContextPerThread;
    private static volatile WebApplicationContext currentContext;
    private WebApplicationContext context;
    private BeanFactoryReference parentContextRef;

    static {
        try {
            ClassPathResource resource = new ClassPathResource(DEFAULT_STRATEGIES_PATH, ContextLoader.class);
            defaultStrategies = PropertiesLoaderUtils.loadProperties((Resource)resource);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Could not load 'ContextLoader.properties': " + ex.getMessage());
        }
        currentContextPerThread = new ConcurrentHashMap<ClassLoader, WebApplicationContext>(1);
    }

    public ContextLoader() {
    }

    public ContextLoader(WebApplicationContext context) {
        this.context = context;
    }

    public WebApplicationContext initWebApplicationContext(ServletContext servletContext) {
        if (servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE) != null) {
            throw new IllegalStateException("Cannot initialize context because there is already a root application context present - check whether you have multiple ContextLoader* definitions in your web.xml!");
        }
        Log logger = LogFactory.getLog(ContextLoader.class);
        servletContext.log("Initializing Spring root WebApplicationContext");
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Root WebApplicationContext: initialization started");
        }
        long startTime = System.currentTimeMillis();
        try {
            if (this.context == null) {
                this.context = this.createWebApplicationContext(servletContext);
            }
            if (this.context instanceof ConfigurableWebApplicationContext) {
                this.configureAndRefreshWebApplicationContext((ConfigurableWebApplicationContext)this.context, servletContext);
            }
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.context);
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl == ContextLoader.class.getClassLoader()) {
                currentContext = this.context;
            } else if (ccl != null) {
                currentContextPerThread.put(ccl, this.context);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Published root WebApplicationContext as ServletContext attribute with name [" + WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE + "]"));
            }
            if (logger.isInfoEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                logger.info((Object)("Root WebApplicationContext: initialization completed in " + elapsedTime + " ms"));
            }
            return this.context;
        }
        catch (RuntimeException ex) {
            logger.error((Object)"Context initialization failed", (Throwable)ex);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)ex);
            throw ex;
        }
        catch (Error err) {
            logger.error((Object)"Context initialization failed", (Throwable)err);
            servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)err);
            throw err;
        }
    }

    protected WebApplicationContext createWebApplicationContext(ServletContext sc) {
        Class<?> contextClass = this.determineContextClass(sc);
        if (!ConfigurableWebApplicationContext.class.isAssignableFrom(contextClass)) {
            throw new ApplicationContextException("Custom context class [" + contextClass.getName() + "] is not of type [" + ConfigurableWebApplicationContext.class.getName() + "]");
        }
        ConfigurableWebApplicationContext wac = (ConfigurableWebApplicationContext)BeanUtils.instantiateClass(contextClass);
        return wac;
    }

    @Deprecated
    protected WebApplicationContext createWebApplicationContext(ServletContext sc, ApplicationContext parent) {
        return this.createWebApplicationContext(sc);
    }

    protected void configureAndRefreshWebApplicationContext(ConfigurableWebApplicationContext wac, ServletContext sc) {
        if (ObjectUtils.identityToString((Object)wac).equals(wac.getId())) {
            if (sc.getMajorVersion() == 2 && sc.getMinorVersion() < 5) {
                String servletContextName = sc.getServletContextName();
                wac.setId(String.valueOf(ConfigurableWebApplicationContext.APPLICATION_CONTEXT_ID_PREFIX) + ObjectUtils.getDisplayString((Object)servletContextName));
            } else {
                try {
                    String contextPath = (String)ServletContext.class.getMethod("getContextPath", new Class[0]).invoke((Object)sc, new Object[0]);
                    wac.setId(String.valueOf(ConfigurableWebApplicationContext.APPLICATION_CONTEXT_ID_PREFIX) + ObjectUtils.getDisplayString((Object)contextPath));
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Failed to invoke Servlet 2.5 getContextPath method", ex);
                }
            }
        }
        ApplicationContext parent = this.loadParentContext(sc);
        wac.setParent(parent);
        wac.setServletContext(sc);
        wac.setConfigLocation(sc.getInitParameter(CONFIG_LOCATION_PARAM));
        this.customizeContext(sc, wac);
        wac.refresh();
    }

    protected Class<?> determineContextClass(ServletContext servletContext) {
        String contextClassName = servletContext.getInitParameter(CONTEXT_CLASS_PARAM);
        if (contextClassName != null) {
            try {
                return ClassUtils.forName((String)contextClassName, (ClassLoader)ClassUtils.getDefaultClassLoader());
            }
            catch (ClassNotFoundException ex) {
                throw new ApplicationContextException("Failed to load custom context class [" + contextClassName + "]", (Throwable)ex);
            }
        }
        contextClassName = defaultStrategies.getProperty(WebApplicationContext.class.getName());
        try {
            return ClassUtils.forName((String)contextClassName, (ClassLoader)ContextLoader.class.getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new ApplicationContextException("Failed to load default context class [" + contextClassName + "]", (Throwable)ex);
        }
    }

    protected List<Class<ApplicationContextInitializer<ConfigurableApplicationContext>>> determineContextInitializerClasses(ServletContext servletContext) {
        String classNames = servletContext.getInitParameter(CONTEXT_INITIALIZER_CLASSES_PARAM);
        ArrayList<Class<ApplicationContextInitializer<ConfigurableApplicationContext>>> classes = new ArrayList<Class<ApplicationContextInitializer<ConfigurableApplicationContext>>>();
        if (classNames != null) {
            String[] stringArray = StringUtils.tokenizeToStringArray((String)classNames, (String)",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String className = stringArray[n2];
                try {
                    Class clazz = ClassUtils.forName((String)className, (ClassLoader)ClassUtils.getDefaultClassLoader());
                    Assert.isAssignable(ApplicationContextInitializer.class, (Class)clazz, (String)("class [" + className + "] must implement ApplicationContextInitializer"));
                    classes.add(clazz);
                }
                catch (ClassNotFoundException ex) {
                    throw new ApplicationContextException("Failed to load context initializer class [" + className + "]", (Throwable)ex);
                }
                ++n2;
            }
        }
        return classes;
    }

    protected void customizeContext(ServletContext servletContext, ConfigurableWebApplicationContext applicationContext) {
        ArrayList<ApplicationContextInitializer> initializerInstances = new ArrayList<ApplicationContextInitializer>();
        for (Class<ApplicationContextInitializer<ConfigurableApplicationContext>> initializerClass : this.determineContextInitializerClasses(servletContext)) {
            Class<?> contextClass = applicationContext.getClass();
            Class initializerContextClass = GenericTypeResolver.resolveTypeArgument(initializerClass, ApplicationContextInitializer.class);
            Assert.isAssignable((Class)initializerContextClass, contextClass, (String)String.format("Could not add context initializer [%s] as its generic parameter [%s] is not assignable from the type of application context used by this context loader [%s]", initializerClass.getName(), initializerContextClass, contextClass));
            initializerInstances.add((ApplicationContextInitializer)BeanUtils.instantiateClass(initializerClass));
        }
        Collections.sort(initializerInstances, new AnnotationAwareOrderComparator());
        for (ApplicationContextInitializer initializer : initializerInstances) {
            initializer.initialize((ConfigurableApplicationContext)applicationContext);
        }
    }

    protected ApplicationContext loadParentContext(ServletContext servletContext) {
        ApplicationContext parentContext = null;
        String locatorFactorySelector = servletContext.getInitParameter(LOCATOR_FACTORY_SELECTOR_PARAM);
        String parentContextKey = servletContext.getInitParameter(LOCATOR_FACTORY_KEY_PARAM);
        if (parentContextKey != null) {
            BeanFactoryLocator locator = ContextSingletonBeanFactoryLocator.getInstance((String)locatorFactorySelector);
            Log logger = LogFactory.getLog(ContextLoader.class);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Getting parent context definition: using parent context key of '" + parentContextKey + "' with BeanFactoryLocator"));
            }
            this.parentContextRef = locator.useBeanFactory(parentContextKey);
            parentContext = (ApplicationContext)this.parentContextRef.getFactory();
        }
        return parentContext;
    }

    public void closeWebApplicationContext(ServletContext servletContext) {
        servletContext.log("Closing Spring root WebApplicationContext");
        try {
            if (this.context instanceof ConfigurableWebApplicationContext) {
                ((ConfigurableWebApplicationContext)this.context).close();
            }
        }
        finally {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            if (ccl == ContextLoader.class.getClassLoader()) {
                currentContext = null;
            } else if (ccl != null) {
                currentContextPerThread.remove(ccl);
            }
            servletContext.removeAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
            if (this.parentContextRef != null) {
                this.parentContextRef.release();
            }
        }
    }

    public static WebApplicationContext getCurrentWebApplicationContext() {
        WebApplicationContext ccpt;
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        if (ccl != null && (ccpt = currentContextPerThread.get(ccl)) != null) {
            return ccpt;
        }
        return currentContext;
    }
}

