/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.ExceptionDepthComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionMethodMapping {
    protected static final Method NO_METHOD_FOUND = ClassUtils.getMethodIfAvailable(System.class, (String)"currentTimeMillis", (Class[])new Class[0]);
    private final Map<Class<? extends Throwable>, Method> mappedExceptionTypes = new HashMap<Class<? extends Throwable>, Method>();
    private final Map<Class<? extends Throwable>, Method> resolvedExceptionTypes = new ConcurrentHashMap<Class<? extends Throwable>, Method>();

    public ExceptionMethodMapping(Set<Method> methods) {
        this.initExceptionMap(methods);
    }

    private void initExceptionMap(Set<Method> methods) {
        for (Method method : methods) {
            for (Class<? extends Throwable> exceptionType : this.getMappedExceptionTypes(method)) {
                Method prevMethod = this.mappedExceptionTypes.put(exceptionType, method);
                if (prevMethod == null || prevMethod.equals(method)) continue;
                throw new IllegalStateException("Ambiguous exception handler mapped for [" + exceptionType + "]: {" + prevMethod + ", " + method + "}.");
            }
        }
    }

    protected List<Class<? extends Throwable>> getMappedExceptionTypes(Method method) {
        ExceptionHandler annotation = (ExceptionHandler)AnnotationUtils.findAnnotation((Method)method, ExceptionHandler.class);
        if (annotation.value().length != 0) {
            return Arrays.asList(annotation.value());
        }
        ArrayList<Class<? extends Throwable>> result = new ArrayList<Class<? extends Throwable>>();
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> paramType = classArray[n2];
            if (Throwable.class.isAssignableFrom(paramType)) {
                result.add(paramType);
            }
            ++n2;
        }
        Assert.notEmpty(result, (String)("No exception types mapped to {" + method + "}"));
        return result;
    }

    public Method getMethod(Exception exception) {
        Class<?> exceptionType = exception.getClass();
        Method method = this.resolvedExceptionTypes.get(exceptionType);
        if (method == null) {
            method = this.resolveExceptionType(exceptionType);
            this.resolvedExceptionTypes.put(exceptionType, method);
        }
        return method != NO_METHOD_FOUND ? method : null;
    }

    protected final Method resolveExceptionType(Class<? extends Exception> exceptionType) {
        ArrayList<Class<? extends Throwable>> matches = new ArrayList<Class<? extends Throwable>>();
        for (Class<? extends Throwable> mappedExceptionType : this.mappedExceptionTypes.keySet()) {
            if (!mappedExceptionType.isAssignableFrom(exceptionType)) continue;
            matches.add(mappedExceptionType);
        }
        if (matches.isEmpty()) {
            return NO_METHOD_FOUND;
        }
        return this.mappedExceptionTypes.get(this.getBestMatchingExceptionType(matches, exceptionType));
    }

    protected Class<? extends Throwable> getBestMatchingExceptionType(List<Class<? extends Throwable>> exceptionTypes, Class<? extends Exception> exceptionType) {
        Assert.isTrue((exceptionTypes.size() > 0 ? 1 : 0) != 0, (String)"No exception types to select from!");
        if (exceptionTypes.size() > 1) {
            Collections.sort(exceptionTypes, new ExceptionDepthComparator(exceptionType));
        }
        return exceptionTypes.get(0);
    }
}

