/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.method.annotation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.core.Conventions;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.MethodParameter;
import org.springframework.ui.ModelMap;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpSessionRequiredException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.method.annotation.SessionAttributesHandler;
import org.springframework.web.method.support.InvocableHandlerMethod;
import org.springframework.web.method.support.ModelAndViewContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelFactory {
    private final List<InvocableHandlerMethod> attributeMethods;
    private final WebDataBinderFactory binderFactory;
    private final SessionAttributesHandler sessionHandler;

    public ModelFactory(List<InvocableHandlerMethod> attributeMethods, WebDataBinderFactory binderFactory, SessionAttributesHandler sessionHandler) {
        this.attributeMethods = attributeMethods != null ? attributeMethods : new ArrayList();
        this.binderFactory = binderFactory;
        this.sessionHandler = sessionHandler;
    }

    public void initModel(NativeWebRequest request, ModelAndViewContainer mavContainer, HandlerMethod requestMethod) throws Exception {
        Map<String, ?> sessionAttributes = this.sessionHandler.retrieveHandlerSessionAttributes(request);
        mavContainer.addAllAttributes(sessionAttributes);
        this.invokeAttributeMethods(request, mavContainer);
        this.checkMissingSessionAttributes(request, mavContainer, requestMethod);
    }

    private void invokeAttributeMethods(NativeWebRequest request, ModelAndViewContainer mavContainer) throws Exception {
        for (InvocableHandlerMethod attrMethod : this.attributeMethods) {
            String modelName = attrMethod.getMethodAnnotation(ModelAttribute.class).value();
            if (mavContainer.containsAttribute(modelName)) continue;
            Object returnValue = attrMethod.invokeForRequest(request, mavContainer, new Object[0]);
            if (attrMethod.isVoid()) continue;
            String valueName = ModelFactory.getNameForReturnValue(returnValue, attrMethod.getReturnType());
            mavContainer.mergeAttribute(valueName, returnValue);
        }
    }

    private void checkMissingSessionAttributes(NativeWebRequest request, ModelAndViewContainer mavContainer, HandlerMethod requestMethod) throws HttpSessionRequiredException {
        MethodParameter[] methodParameterArray = requestMethod.getMethodParameters();
        int n = methodParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            MethodParameter parameter = methodParameterArray[n2];
            if (parameter.hasParameterAnnotation(ModelAttribute.class) && !mavContainer.containsAttribute(name = ModelFactory.getNameForParameter(parameter)) && this.sessionHandler.isHandlerSessionAttribute(name, parameter.getParameterType())) {
                Object attrValue = this.sessionHandler.retrieveAttribute(request, name);
                if (attrValue == null) {
                    throw new HttpSessionRequiredException("Session attribute '" + name + "' not found in session");
                }
                mavContainer.addAttribute(name, attrValue);
            }
            ++n2;
        }
    }

    public static String getNameForReturnValue(Object returnValue, MethodParameter returnType) {
        ModelAttribute annot = (ModelAttribute)returnType.getMethodAnnotation(ModelAttribute.class);
        if (annot != null && StringUtils.hasText((String)annot.value())) {
            return annot.value();
        }
        Method method = returnType.getMethod();
        Class resolvedType = GenericTypeResolver.resolveReturnType((Method)method, (Class)returnType.getDeclaringClass());
        return Conventions.getVariableNameForReturnType((Method)method, (Class)resolvedType, (Object)returnValue);
    }

    public static String getNameForParameter(MethodParameter parameter) {
        ModelAttribute annot = (ModelAttribute)parameter.getParameterAnnotation(ModelAttribute.class);
        String attrName = annot != null ? annot.value() : null;
        return StringUtils.hasText((String)attrName) ? attrName : Conventions.getVariableNameForParameter((MethodParameter)parameter);
    }

    public void updateModel(NativeWebRequest request, ModelAndViewContainer mavContainer, SessionStatus sessionStatus) throws Exception {
        if (sessionStatus.isComplete()) {
            this.sessionHandler.cleanupHandlerSessionAttributes(request);
        }
        this.sessionHandler.storeHandlerSessionAttributes(request, (Map<String, Object>)mavContainer.getModel());
        if (mavContainer.isResolveView()) {
            this.updateBindingResult(request, mavContainer.getModel());
        }
    }

    private void updateBindingResult(NativeWebRequest request, ModelMap model) throws Exception {
        ArrayList keyNames = new ArrayList(model.keySet());
        for (String name : keyNames) {
            String bindingResultKey;
            Object value;
            if (!this.isBindingCandidate(name, value = model.get((Object)name)) || model.containsAttribute(bindingResultKey = String.valueOf(BindingResult.MODEL_KEY_PREFIX) + name)) continue;
            WebDataBinder dataBinder = this.binderFactory.createBinder(request, value, name);
            model.put((Object)bindingResultKey, (Object)dataBinder.getBindingResult());
        }
    }

    private boolean isBindingCandidate(String attributeName, Object value) {
        Class<?> attrType;
        if (attributeName.startsWith(BindingResult.MODEL_KEY_PREFIX)) {
            return false;
        }
        Class<?> clazz = attrType = value != null ? value.getClass() : null;
        if (this.sessionHandler.isHandlerSessionAttribute(attributeName, attrType)) {
            return true;
        }
        return value != null && !value.getClass().isArray() && !(value instanceof Collection) && !(value instanceof Map) && !BeanUtils.isSimpleValueType(value.getClass());
    }
}

