/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import java.util.concurrent.Callable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncTask {
    private final Callable<?> callable;
    private final Long timeout;
    private final String executorName;
    private final AsyncTaskExecutor executor;
    private BeanFactory beanFactory;

    public AsyncTask(long timeout, Callable<?> callable) {
        this(timeout, null, null, callable);
        Assert.notNull((Object)timeout, (String)"Timeout must not be null");
    }

    public AsyncTask(Long timeout, String executorName, Callable<?> callable) {
        this(timeout, null, executorName, callable);
        Assert.notNull((Object)this.executor, (String)"Executor name must not be null");
    }

    public AsyncTask(Long timeout, AsyncTaskExecutor executor, Callable<?> callable) {
        this(timeout, executor, null, callable);
        Assert.notNull((Object)executor, (String)"Executor must not be null");
    }

    private AsyncTask(Long timeout, AsyncTaskExecutor executor, String executorName, Callable<?> callable) {
        Assert.notNull(callable, (String)"Callable must not be null");
        this.callable = callable;
        this.timeout = timeout;
        this.executor = executor;
        this.executorName = executorName;
    }

    public Callable<?> getCallable() {
        return this.callable;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public AsyncTaskExecutor getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        if (this.executorName != null) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"A BeanFactory is required to look up an task executor bean");
            return (AsyncTaskExecutor)this.beanFactory.getBean(this.executorName, AsyncTaskExecutor.class);
        }
        return null;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

