/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeferredResult<T> {
    private static final Log logger = LogFactory.getLog(DeferredResult.class);
    private static final Object RESULT_NONE = new Object();
    private final Object timeoutResult;
    private final Long timeout;
    private DeferredResultHandler resultHandler;
    private Object result = RESULT_NONE;
    private final AtomicBoolean expired = new AtomicBoolean(false);
    private final Object lock = new Object();
    private final CountDownLatch latch = new CountDownLatch(1);

    public DeferredResult() {
        this(null, RESULT_NONE);
    }

    public DeferredResult(long timeout) {
        this(timeout, RESULT_NONE);
    }

    public DeferredResult(Long timeout, Object timeoutResult) {
        this.timeoutResult = timeoutResult;
        this.timeout = timeout;
    }

    public Long getTimeoutMilliseconds() {
        return this.timeout;
    }

    public void setResultHandler(DeferredResultHandler resultHandler) {
        this.resultHandler = resultHandler;
        this.latch.countDown();
    }

    public boolean setResult(T result) {
        return this.processResult(result);
    }

    public boolean setErrorResult(Object result) {
        return this.processResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processResult(Object result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isSetOrExpired()) {
                return false;
            }
            this.result = result;
            if (!this.awaitResultHandler()) {
                throw new IllegalStateException("DeferredResultHandler not set");
            }
            try {
                this.resultHandler.handleResult(result);
            }
            catch (Throwable t) {
                logger.trace((Object)"DeferredResult not handled", t);
                return false;
            }
            return true;
        }
    }

    private boolean awaitResultHandler() {
        try {
            return this.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean isSetOrExpired() {
        return this.expired.get() || this.result != RESULT_NONE;
    }

    void setExpired() {
        this.expired.set(true);
    }

    boolean hasTimeoutResult() {
        return this.timeoutResult != RESULT_NONE;
    }

    boolean applyTimeoutResult() {
        return this.hasTimeoutResult() ? this.processResult(this.timeoutResult) : false;
    }

    public static interface DeferredResultHandler {
        public void handleResult(Object var1);
    }
}

