/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.util.Assert;

abstract class AbstractAsyncClientHttpRequest
implements AsyncClientHttpRequest {
    private final HttpHeaders headers = new HttpHeaders();
    private boolean executed = false;

    AbstractAsyncClientHttpRequest() {
    }

    @Override
    public final HttpHeaders getHeaders() {
        return this.executed ? HttpHeaders.readOnlyHttpHeaders(this.headers) : this.headers;
    }

    @Override
    public final OutputStream getBody() throws IOException {
        this.assertNotExecuted();
        return this.getBodyInternal(this.headers);
    }

    @Override
    public Future<ClientHttpResponse> executeAsync() throws IOException {
        this.assertNotExecuted();
        Future<ClientHttpResponse> result = this.executeInternal(this.headers);
        this.executed = true;
        return result;
    }

    protected void assertNotExecuted() {
        Assert.state((!this.executed ? 1 : 0) != 0, (String)"ClientHttpRequest already executed");
    }

    protected abstract OutputStream getBodyInternal(HttpHeaders var1) throws IOException;

    protected abstract Future<ClientHttpResponse> executeInternal(HttpHeaders var1) throws IOException;
}

