/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Future;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.AbstractAsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;

abstract class AbstractBufferingAsyncClientHttpRequest
extends AbstractAsyncClientHttpRequest {
    private ByteArrayOutputStream bufferedOutput = new ByteArrayOutputStream();

    AbstractBufferingAsyncClientHttpRequest() {
    }

    @Override
    protected OutputStream getBodyInternal(HttpHeaders headers) throws IOException {
        return this.bufferedOutput;
    }

    @Override
    protected Future<ClientHttpResponse> executeInternal(HttpHeaders headers) throws IOException {
        byte[] bytes = this.bufferedOutput.toByteArray();
        if (headers.getContentLength() == -1L) {
            headers.setContentLength(bytes.length);
        }
        Future<ClientHttpResponse> result = this.executeInternal(headers, bytes);
        this.bufferedOutput = null;
        return result;
    }

    protected abstract Future<ClientHttpResponse> executeInternal(HttpHeaders var1, byte[] var2) throws IOException;
}

