/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.nio.client.HttpAsyncClient;
import org.apache.http.nio.entity.NByteArrayEntity;
import org.apache.http.protocol.HttpContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractBufferingAsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsAsyncClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequest;

final class HttpComponentsAsyncClientHttpRequest
extends AbstractBufferingAsyncClientHttpRequest {
    private final HttpAsyncClient httpClient;
    private final HttpUriRequest httpRequest;
    private final HttpContext httpContext;

    public HttpComponentsAsyncClientHttpRequest(HttpAsyncClient httpClient, HttpUriRequest httpRequest, HttpContext httpContext) {
        this.httpClient = httpClient;
        this.httpRequest = httpRequest;
        this.httpContext = httpContext;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.httpRequest.getMethod());
    }

    @Override
    public URI getURI() {
        return this.httpRequest.getURI();
    }

    @Override
    protected Future<ClientHttpResponse> executeInternal(HttpHeaders headers, byte[] bufferedOutput) throws IOException {
        HttpComponentsClientHttpRequest.addHeaders(this.httpRequest, headers);
        if (this.httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest)this.httpRequest;
            NByteArrayEntity requestEntity = new NByteArrayEntity(bufferedOutput);
            entityEnclosingRequest.setEntity((HttpEntity)requestEntity);
        }
        Future futureResponse = this.httpClient.execute(this.httpRequest, this.httpContext, null);
        return new ClientHttpResponseFuture(futureResponse);
    }

    private static class ClientHttpResponseFuture
    implements Future<ClientHttpResponse> {
        private final Future<HttpResponse> futureResponse;

        public ClientHttpResponseFuture(Future<HttpResponse> futureResponse) {
            this.futureResponse = futureResponse;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.futureResponse.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.futureResponse.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.futureResponse.isDone();
        }

        @Override
        public ClientHttpResponse get() throws InterruptedException, ExecutionException {
            HttpResponse response = this.futureResponse.get();
            return new HttpComponentsAsyncClientHttpResponse(response);
        }

        @Override
        public ClientHttpResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            HttpResponse response = this.futureResponse.get(timeout, unit);
            return new HttpComponentsAsyncClientHttpResponse(response);
        }
    }
}

