/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractBufferingAsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpResponse;
import org.springframework.util.FileCopyUtils;

final class SimpleBufferingAsyncClientHttpRequest
extends AbstractBufferingAsyncClientHttpRequest {
    private final HttpURLConnection connection;
    private final boolean outputStreaming;
    private final AsyncTaskExecutor taskExecutor;

    SimpleBufferingAsyncClientHttpRequest(HttpURLConnection connection, boolean outputStreaming, AsyncTaskExecutor taskExecutor) {
        this.connection = connection;
        this.outputStreaming = outputStreaming;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.connection.getRequestMethod());
    }

    @Override
    public URI getURI() {
        try {
            return this.connection.getURL().toURI();
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get HttpURLConnection URI: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected Future<ClientHttpResponse> executeInternal(final HttpHeaders headers, final byte[] bufferedOutput) throws IOException {
        return this.taskExecutor.submit((Callable)new Callable<ClientHttpResponse>(){

            @Override
            public ClientHttpResponse call() throws Exception {
                for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                    String headerName = entry.getKey();
                    for (String headerValue : entry.getValue()) {
                        SimpleBufferingAsyncClientHttpRequest.this.connection.addRequestProperty(headerName, headerValue);
                    }
                }
                if (SimpleBufferingAsyncClientHttpRequest.this.connection.getDoOutput() && SimpleBufferingAsyncClientHttpRequest.this.outputStreaming) {
                    SimpleBufferingAsyncClientHttpRequest.this.connection.setFixedLengthStreamingMode(bufferedOutput.length);
                }
                SimpleBufferingAsyncClientHttpRequest.this.connection.connect();
                if (SimpleBufferingAsyncClientHttpRequest.this.connection.getDoOutput()) {
                    FileCopyUtils.copy((byte[])bufferedOutput, (OutputStream)SimpleBufferingAsyncClientHttpRequest.this.connection.getOutputStream());
                }
                return new SimpleClientHttpResponse(SimpleBufferingAsyncClientHttpRequest.this.connection);
            }
        });
    }
}

