/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.InvalidClassException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteInvocationFailureException;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.httpinvoker.HttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.SimpleHttpInvokerRequestExecutor;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationBasedAccessor;
import org.springframework.remoting.support.RemoteInvocationResult;

public class HttpInvokerClientInterceptor
extends RemoteInvocationBasedAccessor
implements MethodInterceptor,
HttpInvokerClientConfiguration {
    private String codebaseUrl;
    private HttpInvokerRequestExecutor httpInvokerRequestExecutor;

    public void setCodebaseUrl(String codebaseUrl) {
        this.codebaseUrl = codebaseUrl;
    }

    @Override
    public String getCodebaseUrl() {
        return this.codebaseUrl;
    }

    public void setHttpInvokerRequestExecutor(HttpInvokerRequestExecutor httpInvokerRequestExecutor) {
        this.httpInvokerRequestExecutor = httpInvokerRequestExecutor;
    }

    public HttpInvokerRequestExecutor getHttpInvokerRequestExecutor() {
        if (this.httpInvokerRequestExecutor == null) {
            SimpleHttpInvokerRequestExecutor executor = new SimpleHttpInvokerRequestExecutor();
            executor.setBeanClassLoader(this.getBeanClassLoader());
            this.httpInvokerRequestExecutor = executor;
        }
        return this.httpInvokerRequestExecutor;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.getHttpInvokerRequestExecutor();
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        if (AopUtils.isToStringMethod((Method)methodInvocation.getMethod())) {
            return "HTTP invoker proxy for service URL [" + this.getServiceUrl() + "]";
        }
        RemoteInvocation invocation = this.createRemoteInvocation(methodInvocation);
        RemoteInvocationResult result = null;
        try {
            result = this.executeRequest(invocation, methodInvocation);
        }
        catch (Throwable ex) {
            throw this.convertHttpInvokerAccessException(ex);
        }
        try {
            return this.recreateRemoteInvocationResult(result);
        }
        catch (Throwable ex) {
            if (result.hasInvocationTargetException()) {
                throw ex;
            }
            throw new RemoteInvocationFailureException("Invocation of method [" + methodInvocation.getMethod() + "] failed in HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
        }
    }

    protected RemoteInvocationResult executeRequest(RemoteInvocation invocation, MethodInvocation originalInvocation) throws Exception {
        return this.executeRequest(invocation);
    }

    protected RemoteInvocationResult executeRequest(RemoteInvocation invocation) throws Exception {
        return this.getHttpInvokerRequestExecutor().executeRequest(this, invocation);
    }

    protected RemoteAccessException convertHttpInvokerAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            throw new RemoteConnectFailureException("Could not connect to HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
        }
        if (ex instanceof ClassNotFoundException || ex instanceof NoClassDefFoundError || ex instanceof InvalidClassException) {
            throw new RemoteAccessException("Could not deserialize result from HTTP invoker remote service [" + this.getServiceUrl() + "]", ex);
        }
        throw new RemoteAccessException("Could not access HTTP invoker remote service at [" + this.getServiceUrl() + "]", ex);
    }
}

