/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind;

import java.util.Iterator;
import java.util.Map;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestBindingException;

public class UnsatisfiedServletRequestParameterException
extends ServletRequestBindingException {
    private final String[] paramConditions;
    private final Map<String, String[]> actualParams;

    public UnsatisfiedServletRequestParameterException(String[] paramConditions, Map actualParams) {
        super("");
        this.paramConditions = paramConditions;
        this.actualParams = actualParams;
    }

    @Override
    public String getMessage() {
        return "Parameter conditions \"" + StringUtils.arrayToDelimitedString((Object[])this.paramConditions, (String)", ") + "\" not met for actual request parameters: " + UnsatisfiedServletRequestParameterException.requestParameterMapToString(this.actualParams);
    }

    private static String requestParameterMapToString(Map<String, String[]> actualParams) {
        StringBuilder result = new StringBuilder();
        Iterator<Map.Entry<String, String[]>> it = actualParams.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String[]> entry = it.next();
            result.append(entry.getKey()).append('=').append(ObjectUtils.nullSafeToString((Object[])entry.getValue()));
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public final String[] getParamConditions() {
        return this.paramConditions;
    }

    public final Map<String, String[]> getActualParams() {
        return this.actualParams;
    }
}

