/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.SseEvent;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SseEventHttpMessageWriter
implements HttpMessageWriter<Object> {
    private static final MediaType TEXT_EVENT_STREAM = new MediaType("text", "event-stream");
    private final List<Encoder<?>> dataEncoders;

    public SseEventHttpMessageWriter(List<Encoder<?>> dataEncoders) {
        Assert.notNull(dataEncoders, (String)"'dataEncoders' must not be null");
        this.dataEncoders = dataEncoders;
    }

    @Override
    public boolean canWrite(ResolvableType type, MediaType mediaType) {
        return mediaType == null || TEXT_EVENT_STREAM.isCompatibleWith(mediaType);
    }

    @Override
    public List<MediaType> getWritableMediaTypes() {
        return Collections.singletonList(TEXT_EVENT_STREAM);
    }

    @Override
    public Mono<Void> write(Publisher<?> inputStream, ResolvableType type, MediaType contentType, ReactiveHttpOutputMessage outputMessage) {
        outputMessage.getHeaders().setContentType(TEXT_EVENT_STREAM);
        DataBufferFactory bufferFactory = outputMessage.bufferFactory();
        Flux body = this.encode(inputStream, bufferFactory, type);
        body = body.concatWith((Publisher)Flux.never());
        return outputMessage.writeAndFlushWith((Publisher<Publisher<DataBuffer>>)body);
    }

    private Flux<Publisher<DataBuffer>> encode(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType type) {
        return Flux.from(inputStream).map(input -> {
            MediaType mediaType;
            SseEvent event = SseEvent.class.equals((Object)type.getRawClass()) ? (SseEvent)input : new SseEvent(input);
            StringBuilder sb = new StringBuilder();
            if (event.getId() != null) {
                sb.append("id:");
                sb.append(event.getId());
                sb.append("\n");
            }
            if (event.getName() != null) {
                sb.append("event:");
                sb.append(event.getName());
                sb.append("\n");
            }
            if (event.getReconnectTime() != null) {
                sb.append("retry:");
                sb.append(event.getReconnectTime().toString());
                sb.append("\n");
            }
            if (event.getComment() != null) {
                sb.append(":");
                sb.append(event.getComment().replaceAll("\\n", "\n:"));
                sb.append("\n");
            }
            Object data = event.getData();
            Flux<DataBuffer> dataBuffer = Flux.empty();
            MediaType mediaType2 = mediaType = event.getMediaType() == null ? MediaType.ALL : event.getMediaType();
            if (data != null) {
                sb.append("data:");
                if (data instanceof String) {
                    sb.append(((String)data).replaceAll("\\n", "\ndata:")).append("\n");
                } else {
                    dataBuffer = this.applyEncoder(data, mediaType, bufferFactory);
                }
            }
            return Flux.concat((Publisher[])new Publisher[]{this.encodeString(sb.toString(), bufferFactory), dataBuffer, this.encodeString("\n", bufferFactory)});
        });
    }

    private <T> Flux<DataBuffer> applyEncoder(Object data, MediaType mediaType, DataBufferFactory bufferFactory) {
        ResolvableType elementType = ResolvableType.forClass(data.getClass());
        Optional<Encoder> encoder = this.dataEncoders.stream().filter(e -> e.canEncode(elementType, (MimeType)mediaType, new Object[0])).findFirst();
        return encoder.orElseThrow(() -> new CodecException("No suitable encoder found!")).encode((Publisher)Mono.just((Object)data), bufferFactory, elementType, (MimeType)mediaType, new Object[0]).concatWith(this.encodeString("\n", bufferFactory));
    }

    private Mono<DataBuffer> encodeString(String str, DataBufferFactory bufferFactory) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        DataBuffer buffer = bufferFactory.allocateBuffer(bytes.length).write(bytes);
        return Mono.just((Object)buffer);
    }
}

