/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractDecoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;

class JsonObjectDecoder
extends AbstractDecoder<DataBuffer> {
    private static final int ST_CORRUPTED = -1;
    private static final int ST_INIT = 0;
    private static final int ST_DECODING_NORMAL = 1;
    private static final int ST_DECODING_ARRAY_STREAM = 2;
    private final int maxObjectLength;
    private final boolean streamArrayElements;

    public JsonObjectDecoder() {
        this(0x100000);
    }

    public JsonObjectDecoder(int maxObjectLength) {
        this(maxObjectLength, true);
    }

    public JsonObjectDecoder(boolean streamArrayElements) {
        this(0x100000, streamArrayElements);
    }

    public JsonObjectDecoder(int maxObjectLength, boolean streamArrayElements) {
        super(new MimeType[]{new MimeType("application", "json", StandardCharsets.UTF_8), new MimeType("application", "*+json", StandardCharsets.UTF_8)});
        if (maxObjectLength < 1) {
            throw new IllegalArgumentException("maxObjectLength must be a positive int");
        }
        this.maxObjectLength = maxObjectLength;
        this.streamArrayElements = streamArrayElements;
    }

    public Flux<DataBuffer> decode(Publisher<DataBuffer> inputStream, ResolvableType elementType, MimeType mimeType, Object ... hints) {
        return Flux.from(inputStream).flatMap((Function)new Function<DataBuffer, Publisher<? extends DataBuffer>>(){
            int openBraces;
            int index;
            int state;
            boolean insideString;
            ByteBuf input;
            Integer writerIndex;

            @Override
            public Publisher<? extends DataBuffer> apply(DataBuffer buffer) {
                ArrayList<DataBuffer> chunks = new ArrayList<DataBuffer>();
                if (this.input == null) {
                    this.input = Unpooled.copiedBuffer((ByteBuffer)buffer.asByteBuffer());
                    DataBufferUtils.release((DataBuffer)buffer);
                    this.writerIndex = this.input.writerIndex();
                } else {
                    this.input = Unpooled.copiedBuffer((ByteBuf[])new ByteBuf[]{this.input, Unpooled.copiedBuffer((ByteBuffer)buffer.asByteBuffer())});
                    DataBufferUtils.release((DataBuffer)buffer);
                    this.writerIndex = this.input.writerIndex();
                }
                if (this.state == -1) {
                    this.input.skipBytes(this.input.readableBytes());
                    return Flux.error((Throwable)new IllegalStateException("Corrupted stream"));
                }
                if (this.writerIndex > JsonObjectDecoder.this.maxObjectLength) {
                    this.input.skipBytes(this.input.readableBytes());
                    this.reset();
                    return Flux.error((Throwable)new IllegalStateException("object length exceeds " + JsonObjectDecoder.this.maxObjectLength + ": " + this.writerIndex + " bytes discarded"));
                }
                DataBufferFactory dataBufferFactory = buffer.factory();
                while (this.index < this.writerIndex) {
                    byte c = this.input.getByte(this.index);
                    if (this.state == 1) {
                        this.decodeByte(c, this.input, this.index);
                        if (this.openBraces == 0) {
                            ByteBuf json = this.extractObject(this.input, this.input.readerIndex(), this.index + 1 - this.input.readerIndex());
                            if (json != null) {
                                chunks.add(dataBufferFactory.wrap(json.nioBuffer()));
                            }
                            this.input.readerIndex(this.index + 1);
                            this.reset();
                        }
                    } else if (this.state == 2) {
                        this.decodeByte(c, this.input, this.index);
                        if (!this.insideString && (this.openBraces == 1 && c == 44 || this.openBraces == 0 && c == 93)) {
                            int idxNoSpaces;
                            int i = this.input.readerIndex();
                            while (Character.isWhitespace(this.input.getByte(i))) {
                                this.input.skipBytes(1);
                                ++i;
                            }
                            for (idxNoSpaces = this.index - 1; idxNoSpaces >= this.input.readerIndex() && Character.isWhitespace(this.input.getByte(idxNoSpaces)); --idxNoSpaces) {
                            }
                            ByteBuf json = this.extractObject(this.input, this.input.readerIndex(), idxNoSpaces + 1 - this.input.readerIndex());
                            if (json != null) {
                                chunks.add(dataBufferFactory.wrap(json.nioBuffer()));
                            }
                            this.input.readerIndex(this.index + 1);
                            if (c == 93) {
                                this.reset();
                            }
                        }
                    } else if (c == 123 || c == 91) {
                        this.initDecoding(c, JsonObjectDecoder.this.streamArrayElements);
                        if (this.state == 2) {
                            this.input.skipBytes(1);
                        }
                    } else if (Character.isWhitespace(c)) {
                        this.input.skipBytes(1);
                    } else {
                        this.state = -1;
                        return Flux.error((Throwable)new IllegalStateException("invalid JSON received at byte position " + this.index + ": " + ByteBufUtil.hexDump((ByteBuf)this.input)));
                    }
                    ++this.index;
                }
                if (this.input.readableBytes() == 0) {
                    this.index = 0;
                }
                return Flux.fromIterable(chunks);
            }

            protected ByteBuf extractObject(ByteBuf buffer, int index, int length) {
                return buffer.slice(index, length).retain();
            }

            private void decodeByte(byte c, ByteBuf input, int index) {
                if (!(c != 123 && c != 91 || this.insideString)) {
                    ++this.openBraces;
                } else if (!(c != 125 && c != 93 || this.insideString)) {
                    --this.openBraces;
                } else if (c == 34) {
                    if (!this.insideString) {
                        this.insideString = true;
                    } else if (input.getByte(index - 1) != 92) {
                        this.insideString = false;
                    }
                }
            }

            private void initDecoding(byte openingBrace, boolean streamArrayElements) {
                this.openBraces = 1;
                this.state = openingBrace == 91 && streamArrayElements ? 2 : 1;
            }

            private void reset() {
                this.insideString = false;
                this.state = 0;
                this.openBraces = 0;
            }
        });
    }
}

