/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.undertow.server.HttpServerExchange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.UndertowServerHttpRequest;
import org.springframework.http.server.reactive.UndertowServerHttpResponse;
import org.springframework.util.Assert;

public class UndertowHttpHandlerAdapter
implements io.undertow.server.HttpHandler {
    private static Log logger = LogFactory.getLog(UndertowHttpHandlerAdapter.class);
    private final HttpHandler delegate;
    private final DataBufferFactory dataBufferFactory;

    public UndertowHttpHandlerAdapter(HttpHandler delegate, DataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)delegate, (String)"'delegate' is required");
        Assert.notNull((Object)dataBufferFactory, (String)"'dataBufferFactory' must not be null");
        this.delegate = delegate;
        this.dataBufferFactory = dataBufferFactory;
    }

    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        UndertowServerHttpRequest request = new UndertowServerHttpRequest(exchange, this.dataBufferFactory);
        UndertowServerHttpResponse response = new UndertowServerHttpResponse(exchange, this.dataBufferFactory);
        this.delegate.handle(request, response).subscribe((Subscriber)new Subscriber<Void>(){

            public void onSubscribe(Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            public void onNext(Void aVoid) {
            }

            public void onError(Throwable ex) {
                logger.error((Object)"Error from request handling. Completing the request.", ex);
                if (!exchange.isResponseStarted() && exchange.getStatusCode() <= 500) {
                    exchange.setStatusCode(500);
                }
                exchange.endExchange();
            }

            public void onComplete() {
                exchange.endExchange();
            }
        });
    }
}

