/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive;

import java.util.List;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.reactive.BodyExtractor;
import org.springframework.web.client.reactive.ResponseExtractor;
import org.springframework.web.client.reactive.WebClientException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ResponseExtractors {
    private static final Object EMPTY_BODY = new Object();

    public static <T> ResponseExtractor<Mono<T>> body(ResolvableType bodyType) {
        return (clientResponse, webClientConfig) -> clientResponse.doOnNext(response -> webClientConfig.getResponseErrorHandler().handleError((ClientHttpResponse)response, webClientConfig.getMessageReaders())).flatMap(resp -> ResponseExtractors.decodeResponseBodyAsMono(resp, bodyType, webClientConfig.getMessageReaders())).next();
    }

    public static <T> ResponseExtractor<Mono<T>> body(Class<T> sourceClass) {
        ResolvableType bodyType = ResolvableType.forClass(sourceClass);
        return ResponseExtractors.body(bodyType);
    }

    public static <T> BodyExtractor<Mono<T>> as(ResolvableType bodyType) {
        return (clientResponse, messageConverters) -> ResponseExtractors.decodeResponseBodyAsMono(clientResponse, bodyType, messageConverters);
    }

    public static <T> BodyExtractor<Mono<T>> as(Class<T> sourceClass) {
        ResolvableType bodyType = ResolvableType.forClass(sourceClass);
        return ResponseExtractors.as(bodyType);
    }

    public static <T> ResponseExtractor<Flux<T>> bodyStream(ResolvableType bodyType) {
        return (clientResponse, webClientConfig) -> clientResponse.doOnNext(response -> webClientConfig.getResponseErrorHandler().handleError((ClientHttpResponse)response, webClientConfig.getMessageReaders())).flatMap(resp -> ResponseExtractors.decodeResponseBody(resp, bodyType, webClientConfig.getMessageReaders()));
    }

    public static <T> ResponseExtractor<Flux<T>> bodyStream(Class<T> sourceClass) {
        ResolvableType bodyType = ResolvableType.forClass(sourceClass);
        return ResponseExtractors.bodyStream(bodyType);
    }

    public static <T> BodyExtractor<Flux<T>> asStream(ResolvableType bodyType) {
        return (clientResponse, messageConverters) -> ResponseExtractors.decodeResponseBody(clientResponse, bodyType, messageConverters);
    }

    public static <T> BodyExtractor<Flux<T>> asStream(Class<T> sourceClass) {
        ResolvableType bodyType = ResolvableType.forClass(sourceClass);
        return ResponseExtractors.asStream(bodyType);
    }

    public static <T> ResponseExtractor<Mono<ResponseEntity<T>>> response(ResolvableType bodyType) {
        return (clientResponse, webClientConfig) -> clientResponse.then(response -> Mono.when((Mono)ResponseExtractors.decodeResponseBodyAsMono(response, bodyType, webClientConfig.getMessageReaders()).defaultIfEmpty(EMPTY_BODY), (Mono)Mono.just((Object)response.getHeaders()), (Mono)Mono.just((Object)((Object)response.getStatusCode())))).map(tuple -> {
            Object body = tuple.getT1() != EMPTY_BODY ? tuple.getT1() : null;
            return new ResponseEntity<Object>(body, (MultiValueMap<String, String>)((MultiValueMap)tuple.getT2()), (HttpStatus)((Object)((Object)((Object)tuple.getT3()))));
        });
    }

    public static <T> ResponseExtractor<Mono<ResponseEntity<T>>> response(Class<T> bodyClass) {
        ResolvableType bodyType = ResolvableType.forClass(bodyClass);
        return ResponseExtractors.response(bodyType);
    }

    public static <T> ResponseExtractor<Mono<ResponseEntity<Flux<T>>>> responseStream(ResolvableType type) {
        return (clientResponse, webClientConfig) -> clientResponse.map(response -> new ResponseEntity(ResponseExtractors.decodeResponseBody(response, type, webClientConfig.getMessageReaders()), (MultiValueMap<String, String>)response.getHeaders(), response.getStatusCode()));
    }

    public static <T> ResponseExtractor<Mono<ResponseEntity<Flux<T>>>> responseStream(Class<T> sourceClass) {
        ResolvableType resolvableType = ResolvableType.forClass(sourceClass);
        return ResponseExtractors.responseStream(resolvableType);
    }

    public static ResponseExtractor<Mono<HttpHeaders>> headers() {
        return (clientResponse, webClientConfig) -> clientResponse.map(resp -> resp.getHeaders());
    }

    protected static <T> Flux<T> decodeResponseBody(ClientHttpResponse response, ResolvableType responseType, List<HttpMessageReader<?>> messageReaders) {
        MediaType contentType = response.getHeaders().getContentType();
        HttpMessageReader<?> reader = ResponseExtractors.resolveMessageReader(messageReaders, responseType, contentType);
        return reader.read(responseType, response);
    }

    protected static <T> Mono<T> decodeResponseBodyAsMono(ClientHttpResponse response, ResolvableType responseType, List<HttpMessageReader<?>> messageReaders) {
        MediaType contentType = response.getHeaders().getContentType();
        HttpMessageReader<?> reader = ResponseExtractors.resolveMessageReader(messageReaders, responseType, contentType);
        return reader.readMono(responseType, response);
    }

    protected static HttpMessageReader<?> resolveMessageReader(List<HttpMessageReader<?>> messageReaders, ResolvableType responseType, MediaType contentType) {
        return messageReaders.stream().filter(e -> e.canRead(responseType, contentType)).findFirst().orElseThrow(() -> new WebClientException("Could not decode response body of type '" + contentType + "' with target type '" + responseType.toString() + "'"));
    }
}

