/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.ResourceRegionEncoder;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourceRegion;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import reactor.core.publisher.Mono;

class ResourceRegionHttpMessageWriter
extends EncoderHttpMessageWriter<ResourceRegion> {
    public static final String BOUNDARY_STRING_HINT = ResourceRegionHttpMessageWriter.class.getName() + ".boundaryString";

    public ResourceRegionHttpMessageWriter() {
        super(new ResourceRegionEncoder());
    }

    public ResourceRegionHttpMessageWriter(int bufferSize) {
        super(new ResourceRegionEncoder(bufferSize));
    }

    @Override
    public Mono<Void> write(Publisher<? extends ResourceRegion> inputStream, ResolvableType type, MediaType contentType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        if (hints != null && hints.containsKey(BOUNDARY_STRING_HINT)) {
            String boundary = (String)hints.get(BOUNDARY_STRING_HINT);
            hints.put(ResourceRegionEncoder.BOUNDARY_STRING_HINT, boundary);
            outputMessage.getHeaders().setContentType(MediaType.parseMediaType("multipart/byteranges;boundary=" + boundary));
            return super.write(inputStream, type, contentType, outputMessage, hints);
        }
        return Mono.from(inputStream).then(region -> {
            this.writeSingleResourceRegionHeaders((ResourceRegion)region, contentType, outputMessage);
            return this.writeResourceRegion((ResourceRegion)region, type, outputMessage);
        });
    }

    private void writeSingleResourceRegionHeaders(ResourceRegion region, MediaType contentType, ReactiveHttpOutputMessage outputMessage) {
        OptionalLong resourceLength = this.contentLength(region.getResource());
        resourceLength.ifPresent(length -> {
            long start = region.getPosition();
            long end = start + region.getCount() - 1L;
            end = Math.min(end, length - 1L);
            outputMessage.getHeaders().add("Content-Range", "bytes " + start + "-" + end + "/" + length);
            outputMessage.getHeaders().setContentLength(end - start + 1L);
        });
        outputMessage.getHeaders().setContentType(contentType);
    }

    private OptionalLong contentLength(Resource resource) {
        if (InputStreamResource.class != resource.getClass()) {
            try {
                return OptionalLong.of(resource.contentLength());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return OptionalLong.empty();
    }

    private Mono<Void> writeResourceRegion(ResourceRegion region, ResolvableType type, ReactiveHttpOutputMessage outputMessage) {
        Optional<File> file;
        if (outputMessage instanceof ZeroCopyHttpOutputMessage && (file = ResourceRegionHttpMessageWriter.getFile(region.getResource())).isPresent()) {
            ZeroCopyHttpOutputMessage zeroCopyResponse = (ZeroCopyHttpOutputMessage)outputMessage;
            return zeroCopyResponse.writeWith(file.get(), region.getPosition(), region.getCount());
        }
        return super.write(Mono.just((Object)region), type, outputMessage.getHeaders().getContentType(), outputMessage, Collections.emptyMap());
    }

    private static Optional<File> getFile(Resource resource) {
        if (resource.isFile()) {
            try {
                return Optional.of(resource.getFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }
}

