/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ResponseBodyWriteResultPublisher;

abstract class AbstractResponseBodyFlushProcessor
implements Processor<Publisher<DataBuffer>, Void> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ResponseBodyWriteResultPublisher resultPublisher = new ResponseBodyWriteResultPublisher();
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    private volatile boolean subscriberCompleted;
    private Subscription subscription;

    AbstractResponseBodyFlushProcessor() {
    }

    public final void onSubscribe(Subscription subscription) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onSubscribe: " + subscription));
        }
        this.state.get().onSubscribe(this, subscription);
    }

    public final void onNext(Publisher<DataBuffer> publisher) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onNext: " + publisher));
        }
        this.state.get().onNext(this, publisher);
    }

    public final void onError(Throwable t) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onError: " + t));
        }
        this.state.get().onError(this, t);
    }

    public final void onComplete() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onComplete"));
        }
        this.state.get().onComplete(this);
    }

    public final void subscribe(Subscriber<? super Void> subscriber) {
        this.resultPublisher.subscribe(subscriber);
    }

    protected abstract Processor<DataBuffer, Void> createBodyProcessor();

    protected abstract void flush() throws IOException;

    private boolean changeState(State oldState, State newState) {
        return this.state.compareAndSet(oldState, newState);
    }

    private void writeComplete() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " writeComplete"));
        }
        this.state.get().writeComplete(this);
    }

    private void cancel() {
        this.subscription.cancel();
    }

    private static enum State {
        UNSUBSCRIBED{

            @Override
            public void onSubscribe(AbstractResponseBodyFlushProcessor processor, Subscription subscription) {
                Objects.requireNonNull(subscription, "Subscription cannot be null");
                if (processor.changeState(this, 1.REQUESTED)) {
                    processor.subscription = subscription;
                    subscription.request(1L);
                } else {
                    super.onSubscribe(processor, subscription);
                }
            }
        }
        ,
        REQUESTED{

            @Override
            public void onNext(AbstractResponseBodyFlushProcessor processor, Publisher<DataBuffer> chunk) {
                if (processor.changeState(this, 2.RECEIVED)) {
                    Processor<DataBuffer, Void> chunkProcessor = processor.createBodyProcessor();
                    chunk.subscribe(chunkProcessor);
                    chunkProcessor.subscribe((Subscriber)new WriteSubscriber(processor));
                }
            }

            @Override
            public void onComplete(AbstractResponseBodyFlushProcessor processor) {
                if (processor.changeState(this, 2.COMPLETED)) {
                    processor.resultPublisher.publishComplete();
                }
            }
        }
        ,
        RECEIVED{

            @Override
            public void writeComplete(AbstractResponseBodyFlushProcessor processor) {
                try {
                    processor.flush();
                }
                catch (IOException ex) {
                    processor.cancel();
                    processor.onError(ex);
                }
                if (processor.subscriberCompleted) {
                    if (processor.changeState(this, 3.COMPLETED)) {
                        processor.resultPublisher.publishComplete();
                    }
                } else if (processor.changeState(this, 3.REQUESTED)) {
                    processor.subscription.request(1L);
                }
            }

            @Override
            public void onComplete(AbstractResponseBodyFlushProcessor processor) {
                processor.subscriberCompleted = true;
            }
        }
        ,
        COMPLETED{

            @Override
            public void onNext(AbstractResponseBodyFlushProcessor processor, Publisher<DataBuffer> publisher) {
            }

            @Override
            public void onError(AbstractResponseBodyFlushProcessor processor, Throwable t) {
            }

            @Override
            public void onComplete(AbstractResponseBodyFlushProcessor processor) {
            }
        };


        public void onSubscribe(AbstractResponseBodyFlushProcessor processor, Subscription subscription) {
            subscription.cancel();
        }

        public void onNext(AbstractResponseBodyFlushProcessor processor, Publisher<DataBuffer> publisher) {
            throw new IllegalStateException(this.toString());
        }

        public void onError(AbstractResponseBodyFlushProcessor processor, Throwable ex) {
            if (processor.changeState(this, State.COMPLETED)) {
                processor.resultPublisher.publishError(ex);
            }
        }

        public void onComplete(AbstractResponseBodyFlushProcessor processor) {
            throw new IllegalStateException(this.toString());
        }

        public void writeComplete(AbstractResponseBodyFlushProcessor processor) {
        }

        private static class WriteSubscriber
        implements Subscriber<Void> {
            private final AbstractResponseBodyFlushProcessor processor;

            public WriteSubscriber(AbstractResponseBodyFlushProcessor processor) {
                this.processor = processor;
            }

            public void onSubscribe(Subscription subscription) {
                subscription.request(Long.MAX_VALUE);
            }

            public void onNext(Void aVoid) {
            }

            public void onError(Throwable ex) {
                this.processor.cancel();
                this.processor.onError(ex);
            }

            public void onComplete() {
                this.processor.writeComplete();
            }
        }
    }
}

