/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.ChannelSendOperator;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Mono;

public abstract class AbstractServerHttpResponse
implements ServerHttpResponse {
    private static final int STATE_NEW = 1;
    private static final int STATE_COMMITTING = 2;
    private static final int STATE_COMMITTED = 3;
    private final Log logger = LogFactory.getLog(this.getClass());
    private final DataBufferFactory dataBufferFactory;
    private final HttpHeaders headers;
    private final MultiValueMap<String, ResponseCookie> cookies;
    private final List<Supplier<? extends Mono<Void>>> beforeCommitActions = new ArrayList<Supplier<? extends Mono<Void>>>(4);
    private final AtomicInteger state = new AtomicInteger(1);
    private HttpStatus statusCode;

    public AbstractServerHttpResponse(DataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)dataBufferFactory, (String)"'dataBufferFactory' must not be null");
        this.dataBufferFactory = dataBufferFactory;
        this.headers = new HttpHeaders();
        this.cookies = new LinkedMultiValueMap();
    }

    @Override
    public final DataBufferFactory bufferFactory() {
        return this.dataBufferFactory;
    }

    @Override
    public boolean setStatusCode(HttpStatus statusCode) {
        Assert.notNull((Object)((Object)statusCode));
        if (1 == this.state.get()) {
            this.statusCode = statusCode;
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Can't set the status " + statusCode.toString() + " because the HTTP response has already been committed"));
        }
        return false;
    }

    @Override
    public HttpStatus getStatusCode() {
        return this.statusCode;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (3 == this.state.get()) {
            return HttpHeaders.readOnlyHttpHeaders(this.headers);
        }
        return this.headers;
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        if (3 == this.state.get()) {
            return CollectionUtils.unmodifiableMultiValueMap(this.cookies);
        }
        return this.cookies;
    }

    @Override
    public void beforeCommit(Supplier<? extends Mono<Void>> action) {
        Assert.notNull(action);
        this.beforeCommitActions.add(action);
    }

    @Override
    public final Mono<Void> writeWith(Publisher<DataBuffer> body) {
        return new ChannelSendOperator<DataBuffer>(body, writePublisher -> this.applyBeforeCommit().then(() -> this.writeWithInternal((Publisher<DataBuffer>)writePublisher)));
    }

    @Override
    public final Mono<Void> writeAndFlushWith(Publisher<Publisher<DataBuffer>> body) {
        return new ChannelSendOperator<Publisher<DataBuffer>>(body, writePublisher -> this.applyBeforeCommit().then(() -> this.writeAndFlushWithInternal((Publisher<Publisher<DataBuffer>>)writePublisher)));
    }

    @Override
    public Mono<Void> setComplete() {
        return this.applyBeforeCommit();
    }

    protected Mono<Void> applyBeforeCommit() {
        Mono mono = Mono.empty();
        if (this.state.compareAndSet(1, 2)) {
            for (Supplier<? extends Mono<Void>> action : this.beforeCommitActions) {
                mono = mono.then(action);
            }
            mono = mono.otherwise(ex -> Mono.empty());
            mono = mono.then(() -> {
                this.state.set(3);
                this.writeStatusCode();
                this.writeHeaders();
                this.writeCookies();
                return Mono.empty();
            });
        }
        return mono;
    }

    protected abstract Mono<Void> writeWithInternal(Publisher<DataBuffer> var1);

    protected abstract Mono<Void> writeAndFlushWithInternal(Publisher<Publisher<DataBuffer>> var1);

    protected abstract void writeStatusCode();

    protected abstract void writeHeaders();

    protected abstract void writeCookies();
}

