/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.ReactorServerHttpRequest;
import org.springframework.http.server.reactive.ReactorServerHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.HttpChannel;

public class ReactorHttpHandlerAdapter
implements Function<HttpChannel, Mono<Void>> {
    private static Log logger = LogFactory.getLog(ReactorHttpHandlerAdapter.class);
    private final HttpHandler delegate;

    public ReactorHttpHandlerAdapter(HttpHandler delegate) {
        Assert.notNull((Object)delegate, (String)"HttpHandler delegate is required");
        this.delegate = delegate;
    }

    @Override
    public Mono<Void> apply(HttpChannel channel) {
        NettyDataBufferFactory bufferFactory = new NettyDataBufferFactory(channel.delegate().alloc());
        ReactorServerHttpRequest adaptedRequest = new ReactorServerHttpRequest(channel, bufferFactory);
        ReactorServerHttpResponse adaptedResponse = new ReactorServerHttpResponse(channel, (DataBufferFactory)bufferFactory);
        return this.delegate.handle(adaptedRequest, adaptedResponse).otherwise(ex -> {
            logger.debug((Object)"Could not complete request", ex);
            channel.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return Mono.empty();
        }).doOnSuccess(aVoid -> logger.debug((Object)"Successfully completed request"));
    }
}

