/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.cookie.Cookie;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.adapter.RxJava1Adapter;
import reactor.core.publisher.Flux;
import rx.Observable;

public class RxNettyServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpServerRequest<ByteBuf> request;
    private final NettyDataBufferFactory dataBufferFactory;

    public RxNettyServerHttpRequest(HttpServerRequest<ByteBuf> request, NettyDataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)"'request', request must not be null");
        Assert.notNull((Object)dataBufferFactory, (String)"'dataBufferFactory' must not be null");
        this.dataBufferFactory = dataBufferFactory;
        this.request = request;
    }

    public HttpServerRequest<ByteBuf> getRxNettyRequest() {
        return this.request;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.request.getHttpMethod().name());
    }

    @Override
    protected URI initUri() throws URISyntaxException {
        return new URI(this.request.getUri());
    }

    @Override
    protected HttpHeaders initHeaders() {
        HttpHeaders headers = new HttpHeaders();
        for (String name : this.request.getHeaderNames()) {
            headers.put(name, this.request.getAllHeaderValues((CharSequence)name));
        }
        return headers;
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (String name : this.request.getCookies().keySet()) {
            for (Cookie cookie : (Set)this.request.getCookies().get(name)) {
                HttpCookie httpCookie = new HttpCookie(name, cookie.value());
                cookies.add((Object)name, (Object)httpCookie);
            }
        }
        return cookies;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        Observable content = this.request.getContent().map(arg_0 -> ((NettyDataBufferFactory)this.dataBufferFactory).wrap(arg_0));
        return RxJava1Adapter.observableToFlux((Observable)content);
    }
}

