/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.HeaderValues;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractRequestBodyPublisher;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.xnio.ChannelListener;
import org.xnio.channels.StreamSourceChannel;
import reactor.core.publisher.Flux;

public class UndertowServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpServerExchange exchange;
    private final RequestBodyPublisher body;

    public UndertowServerHttpRequest(HttpServerExchange exchange, DataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)exchange, (String)"'exchange' is required.");
        this.exchange = exchange;
        this.body = new RequestBodyPublisher(exchange, dataBufferFactory);
        this.body.registerListener();
    }

    public HttpServerExchange getUndertowExchange() {
        return this.exchange;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.getUndertowExchange().getRequestMethod().toString());
    }

    @Override
    protected URI initUri() throws URISyntaxException {
        return new URI(this.exchange.getRequestScheme(), null, this.exchange.getHostName(), this.exchange.getHostPort(), this.exchange.getRequestURI(), this.exchange.getQueryString(), null);
    }

    @Override
    protected HttpHeaders initHeaders() {
        HttpHeaders headers = new HttpHeaders();
        for (HeaderValues values : this.getUndertowExchange().getRequestHeaders()) {
            headers.put(values.getHeaderName().toString(), (List<String>)values);
        }
        return headers;
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (String name : this.exchange.getRequestCookies().keySet()) {
            Cookie cookie = (Cookie)this.exchange.getRequestCookies().get(name);
            HttpCookie httpCookie = new HttpCookie(name, cookie.getValue());
            cookies.add((Object)name, (Object)httpCookie);
        }
        return cookies;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return Flux.from((Publisher)this.body);
    }

    private static class RequestBodyPublisher
    extends AbstractRequestBodyPublisher {
        private final ChannelListener<StreamSourceChannel> readListener = new ReadListener();
        private final ChannelListener<StreamSourceChannel> closeListener = new CloseListener();
        private final StreamSourceChannel requestChannel;
        private final DataBufferFactory dataBufferFactory;
        private final PooledByteBuffer pooledByteBuffer;

        public RequestBodyPublisher(HttpServerExchange exchange, DataBufferFactory dataBufferFactory) {
            this.requestChannel = exchange.getRequestChannel();
            this.pooledByteBuffer = exchange.getConnection().getByteBufferPool().allocate();
            this.dataBufferFactory = dataBufferFactory;
        }

        private void registerListener() {
            this.requestChannel.getReadSetter().set(this.readListener);
            this.requestChannel.getCloseSetter().set(this.closeListener);
            this.requestChannel.resumeReads();
        }

        @Override
        protected void checkOnDataAvailable() {
            this.onDataAvailable();
        }

        @Override
        protected DataBuffer read() throws IOException {
            ByteBuffer byteBuffer = this.pooledByteBuffer.getBuffer();
            int read = this.requestChannel.read(byteBuffer);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("read:" + read));
            }
            if (read > 0) {
                byteBuffer.flip();
                return this.dataBufferFactory.wrap(byteBuffer);
            }
            if (read == -1) {
                this.onAllDataRead();
            }
            return null;
        }

        private class CloseListener
        implements ChannelListener<StreamSourceChannel> {
            private CloseListener() {
            }

            public void handleEvent(StreamSourceChannel channel) {
                RequestBodyPublisher.this.onAllDataRead();
            }
        }

        private class ReadListener
        implements ChannelListener<StreamSourceChannel> {
            private ReadListener() {
            }

            public void handleEvent(StreamSourceChannel channel) {
                RequestBodyPublisher.this.onDataAvailable();
            }
        }
    }
}

