/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.reactive.ClientWebRequest;
import org.springframework.web.client.reactive.ClientWebRequestBuilder;
import org.springframework.web.client.reactive.ClientWebRequestPostProcessor;
import org.springframework.web.util.DefaultUriTemplateHandler;
import org.springframework.web.util.UriTemplateHandler;
import reactor.core.publisher.Mono;

public class DefaultClientWebRequestBuilder
implements ClientWebRequestBuilder {
    private final UriTemplateHandler uriTemplateHandler = new DefaultUriTemplateHandler();
    private HttpMethod httpMethod;
    private HttpHeaders httpHeaders;
    private URI url;
    private final MultiValueMap<String, HttpCookie> cookies = new LinkedMultiValueMap();
    private Publisher<?> body;
    private ResolvableType elementType;
    private List<ClientWebRequestPostProcessor> postProcessors = new ArrayList<ClientWebRequestPostProcessor>();

    protected DefaultClientWebRequestBuilder() {
    }

    public DefaultClientWebRequestBuilder(HttpMethod httpMethod, String urlTemplate, Object ... urlVariables) {
        this.httpMethod = httpMethod;
        this.httpHeaders = new HttpHeaders();
        this.url = this.uriTemplateHandler.expand(urlTemplate, urlVariables);
    }

    public DefaultClientWebRequestBuilder(HttpMethod httpMethod, URI url) {
        this.httpMethod = httpMethod;
        this.httpHeaders = new HttpHeaders();
        this.url = url;
    }

    public DefaultClientWebRequestBuilder header(String name, String ... values) {
        Arrays.stream(values).forEach(value -> this.httpHeaders.add(name, (String)value));
        return this;
    }

    public DefaultClientWebRequestBuilder headers(HttpHeaders httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public DefaultClientWebRequestBuilder contentType(MediaType contentType) {
        this.httpHeaders.setContentType(contentType);
        return this;
    }

    public DefaultClientWebRequestBuilder contentType(String contentType) {
        this.httpHeaders.setContentType(MediaType.parseMediaType(contentType));
        return this;
    }

    public DefaultClientWebRequestBuilder accept(MediaType ... mediaTypes) {
        this.httpHeaders.setAccept(Arrays.asList(mediaTypes));
        return this;
    }

    public DefaultClientWebRequestBuilder accept(String ... mediaTypes) {
        this.httpHeaders.setAccept(Arrays.stream(mediaTypes).map(type -> MediaType.parseMediaType(type)).collect(Collectors.toList()));
        return this;
    }

    public DefaultClientWebRequestBuilder cookie(String name, String value) {
        return this.cookie(new HttpCookie(name, value));
    }

    public DefaultClientWebRequestBuilder cookie(HttpCookie cookie) {
        this.cookies.add((Object)cookie.getName(), (Object)cookie);
        return this;
    }

    public DefaultClientWebRequestBuilder apply(ClientWebRequestPostProcessor postProcessor) {
        Assert.notNull((Object)postProcessor, (String)"`postProcessor` is required");
        this.postProcessors.add(postProcessor);
        return this;
    }

    public DefaultClientWebRequestBuilder body(Object content) {
        this.body = Mono.just((Object)content);
        this.elementType = ResolvableType.forInstance((Object)content);
        return this;
    }

    public DefaultClientWebRequestBuilder body(Publisher<?> content, ResolvableType publisherType) {
        this.body = content;
        this.elementType = publisherType;
        return this;
    }

    @Override
    public ClientWebRequest build() {
        ClientWebRequest clientWebRequest = new ClientWebRequest(this.httpMethod, this.url);
        clientWebRequest.setHttpHeaders(this.httpHeaders);
        clientWebRequest.setCookies(this.cookies);
        clientWebRequest.setBody(this.body);
        clientWebRequest.setElementType(this.elementType);
        for (ClientWebRequestPostProcessor postProcessor : this.postProcessors) {
            clientWebRequest = postProcessor.postProcess(clientWebRequest);
        }
        return clientWebRequest;
    }
}

