/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.ByteBufferDecoder;
import org.springframework.core.codec.ByteBufferEncoder;
import org.springframework.core.codec.CharSequenceEncoder;
import org.springframework.core.codec.ResourceDecoder;
import org.springframework.core.codec.StringDecoder;
import org.springframework.http.HttpMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.DecoderHttpMessageReader;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.ResourceHttpMessageWriter;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.codec.xml.Jaxb2XmlDecoder;
import org.springframework.http.codec.xml.Jaxb2XmlEncoder;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.web.client.reactive.ClientHttpRequestInterceptionChain;
import org.springframework.web.client.reactive.ClientHttpRequestInterceptor;
import org.springframework.web.client.reactive.ClientWebRequest;
import org.springframework.web.client.reactive.ClientWebRequestBuilder;
import org.springframework.web.client.reactive.DefaultResponseErrorHandler;
import org.springframework.web.client.reactive.ResponseErrorHandler;
import org.springframework.web.client.reactive.ResponseExtractor;
import org.springframework.web.client.reactive.WebClientConfig;
import org.springframework.web.client.reactive.WebResponseActions;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public final class WebClient {
    private static final boolean jackson2Present = ClassUtils.isPresent((String)"com.fasterxml.jackson.databind.ObjectMapper", (ClassLoader)WebClient.class.getClassLoader()) && ClassUtils.isPresent((String)"com.fasterxml.jackson.core.JsonGenerator", (ClassLoader)WebClient.class.getClassLoader());
    private static final boolean jaxb2Present = ClassUtils.isPresent((String)"javax.xml.bind.Binder", (ClassLoader)WebClient.class.getClassLoader());
    private ClientHttpConnector clientHttpConnector;
    private List<ClientHttpRequestInterceptor> interceptors;
    private final DefaultWebClientConfig webClientConfig;

    public WebClient(ClientHttpConnector clientHttpConnector) {
        this.clientHttpConnector = clientHttpConnector;
        this.webClientConfig = new DefaultWebClientConfig();
        this.webClientConfig.setResponseErrorHandler(new DefaultResponseErrorHandler());
    }

    protected final void addDefaultHttpMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        messageReaders.add(new DecoderHttpMessageReader(new ByteBufferDecoder()));
        messageReaders.add(new DecoderHttpMessageReader(new StringDecoder(false)));
        messageReaders.add(new DecoderHttpMessageReader(new ResourceDecoder()));
        if (jaxb2Present) {
            messageReaders.add(new DecoderHttpMessageReader(new Jaxb2XmlDecoder()));
        }
        if (jackson2Present) {
            messageReaders.add(new DecoderHttpMessageReader<Object>(new Jackson2JsonDecoder()));
        }
    }

    protected final void addDefaultHttpMessageWriters(List<HttpMessageWriter<?>> messageWriters) {
        messageWriters.add(new EncoderHttpMessageWriter(new ByteBufferEncoder()));
        messageWriters.add(new EncoderHttpMessageWriter(new CharSequenceEncoder()));
        messageWriters.add(new ResourceHttpMessageWriter());
        if (jaxb2Present) {
            messageWriters.add(new EncoderHttpMessageWriter(new Jaxb2XmlEncoder()));
        }
        if (jackson2Present) {
            messageWriters.add(new EncoderHttpMessageWriter<Object>(new Jackson2JsonEncoder()));
        }
    }

    public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
        this.webClientConfig.setMessageReaders(messageReaders);
    }

    public void setMessageWriters(List<HttpMessageWriter<?>> messageWrters) {
        this.webClientConfig.setMessageWriters(messageWrters);
    }

    public void setResponseErrorHandler(ResponseErrorHandler responseErrorHandler) {
        this.webClientConfig.setResponseErrorHandler(responseErrorHandler);
    }

    public void setInterceptors(List<ClientHttpRequestInterceptor> interceptors) {
        this.interceptors = interceptors != null ? Collections.unmodifiableList(interceptors) : Collections.emptyList();
    }

    public WebResponseActions perform(ClientWebRequestBuilder builder) {
        ClientWebRequest clientWebRequest = builder.build();
        DefaultClientHttpRequestInterceptionChain interception = new DefaultClientHttpRequestInterceptionChain(this.clientHttpConnector, this.interceptors, clientWebRequest);
        final Mono clientResponse = interception.intercept(clientWebRequest.getMethod(), clientWebRequest.getUrl(), null).log("org.springframework.web.client.reactive", Level.FINE, new SignalType[0]);
        return new WebResponseActions(){

            @Override
            public void doWithStatus(Consumer<HttpStatus> consumer) {
                clientResponse.doOnNext(clientHttpResponse -> consumer.accept(clientHttpResponse.getStatusCode()));
            }

            @Override
            public <T> T extract(ResponseExtractor<T> extractor) {
                return extractor.extract((Mono<ClientHttpResponse>)clientResponse, WebClient.this.webClientConfig);
            }
        };
    }

    protected class DefaultClientHttpRequestInterceptionChain
    implements ClientHttpRequestInterceptionChain {
        private final ClientHttpConnector connector;
        private final List<ClientHttpRequestInterceptor> interceptors;
        private final ClientWebRequest clientWebRequest;
        private final List<Consumer<? super HttpMessage>> requestCustomizers;
        private int index;

        public DefaultClientHttpRequestInterceptionChain(ClientHttpConnector connector, List<ClientHttpRequestInterceptor> interceptors, ClientWebRequest clientWebRequest) {
            Assert.notNull((Object)connector, (String)"ClientHttpConnector should not be null");
            this.connector = connector;
            this.interceptors = interceptors;
            this.clientWebRequest = clientWebRequest;
            this.requestCustomizers = new ArrayList<Consumer<? super HttpMessage>>();
            this.index = 0;
        }

        @Override
        public Mono<ClientHttpResponse> intercept(HttpMethod method, URI uri, Consumer<? super HttpMessage> requestCustomizer) {
            if (requestCustomizer != null) {
                this.requestCustomizers.add(requestCustomizer);
            }
            if (this.interceptors != null && this.index < this.interceptors.size()) {
                ClientHttpRequestInterceptor interceptor = this.interceptors.get(this.index++);
                return interceptor.intercept(method, uri, this);
            }
            return this.connector.connect(method, uri, new DefaultRequestCallback(this.clientWebRequest, this.requestCustomizers));
        }
    }

    protected class DefaultRequestCallback
    implements Function<ClientHttpRequest, Mono<Void>> {
        private final ClientWebRequest clientWebRequest;
        private final List<Consumer<? super HttpMessage>> requestCustomizers;

        public DefaultRequestCallback(ClientWebRequest clientWebRequest, List<Consumer<? super HttpMessage>> requestCustomizers) {
            this.clientWebRequest = clientWebRequest;
            this.requestCustomizers = requestCustomizers;
        }

        @Override
        public Mono<Void> apply(ClientHttpRequest clientHttpRequest) {
            clientHttpRequest.getHeaders().putAll((Map<? extends String, ? extends List<String>>)((Object)this.clientWebRequest.getHttpHeaders()));
            if (clientHttpRequest.getHeaders().getAccept().isEmpty()) {
                clientHttpRequest.getHeaders().setAccept(Collections.singletonList(MediaType.ALL));
            }
            this.clientWebRequest.getCookies().values().stream().flatMap(cookies -> cookies.stream()).forEach(cookie -> clientHttpRequest.getCookies().add((Object)cookie.getName(), cookie));
            this.requestCustomizers.forEach(customizer -> customizer.accept(clientHttpRequest));
            if (this.clientWebRequest.getBody() != null) {
                return this.writeRequestBody(this.clientWebRequest.getBody(), this.clientWebRequest.getElementType(), clientHttpRequest, WebClient.this.webClientConfig.getMessageWriters());
            }
            return clientHttpRequest.setComplete();
        }

        protected Mono<Void> writeRequestBody(Publisher<?> content, ResolvableType requestType, ClientHttpRequest request, List<HttpMessageWriter<?>> messageWriters) {
            MediaType contentType = request.getHeaders().getContentType();
            Optional<HttpMessageWriter<?>> messageWriter = this.resolveWriter(messageWriters, requestType, contentType);
            if (!messageWriter.isPresent()) {
                return Mono.error((Throwable)new IllegalStateException("Could not encode request body of type '" + contentType + "' with target type '" + requestType.toString() + "'"));
            }
            return messageWriter.get().write(content, requestType, contentType, request, Collections.emptyMap());
        }

        protected Optional<HttpMessageWriter<?>> resolveWriter(List<HttpMessageWriter<?>> messageWriters, ResolvableType type, MediaType mediaType) {
            return messageWriters.stream().filter(e -> e.canWrite(type, mediaType)).findFirst();
        }
    }

    protected class DefaultWebClientConfig
    implements WebClientConfig {
        private List<HttpMessageReader<?>> messageReaders = new ArrayList();
        private List<HttpMessageWriter<?>> messageWriters;
        private ResponseErrorHandler responseErrorHandler;

        public DefaultWebClientConfig() {
            WebClient.this.addDefaultHttpMessageReaders(this.messageReaders);
            this.messageWriters = new ArrayList();
            WebClient.this.addDefaultHttpMessageWriters(this.messageWriters);
        }

        @Override
        public List<HttpMessageReader<?>> getMessageReaders() {
            return this.messageReaders;
        }

        public void setMessageReaders(List<HttpMessageReader<?>> messageReaders) {
            this.messageReaders = messageReaders;
        }

        @Override
        public List<HttpMessageWriter<?>> getMessageWriters() {
            return this.messageWriters;
        }

        public void setMessageWriters(List<HttpMessageWriter<?>> messageWriters) {
            this.messageWriters = messageWriters;
        }

        @Override
        public ResponseErrorHandler getResponseErrorHandler() {
            return this.responseErrorHandler;
        }

        public void setResponseErrorHandler(ResponseErrorHandler responseErrorHandler) {
            this.responseErrorHandler = responseErrorHandler;
        }
    }
}

