/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive;

import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.web.client.reactive.BodyExtractor;
import org.springframework.web.client.reactive.WebClientException;

public class WebClientResponseException
extends WebClientException {
    private final ClientHttpResponse clientResponse;
    private final List<HttpMessageReader<?>> messageReaders;

    public WebClientResponseException(String message, ClientHttpResponse clientResponse, List<HttpMessageReader<?>> messageReaders) {
        super(message);
        this.clientResponse = clientResponse;
        this.messageReaders = messageReaders;
    }

    public HttpStatus getStatus() {
        return this.clientResponse.getStatusCode();
    }

    public HttpHeaders getResponseHeaders() {
        return this.clientResponse.getHeaders();
    }

    public <T> T getResponseBody(BodyExtractor<T> extractor) {
        return extractor.extract(this.clientResponse, this.messageReaders);
    }
}

