/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.client.reactive.support;

import java.util.Collections;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.reactive.BodyExtractor;
import org.springframework.web.client.reactive.ResponseExtractor;
import org.springframework.web.client.reactive.WebClientException;
import reactor.adapter.RxJava1Adapter;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.Single;

public class RxJava1ResponseExtractors {
    public static <T> ResponseExtractor<Single<T>> body(ResolvableType bodyType) {
        return (clientResponse, webClientConfig) -> RxJava1Adapter.publisherToSingle((Publisher)clientResponse.doOnNext(response -> webClientConfig.getResponseErrorHandler().handleError((ClientHttpResponse)response, webClientConfig.getMessageReaders())).flatMap(resp -> RxJava1ResponseExtractors.decodeResponseBodyAsMono(resp, bodyType, webClientConfig.getMessageReaders())));
    }

    public static <T> ResponseExtractor<Single<T>> body(Class<T> sourceClass) {
        ResolvableType bodyType = ResolvableType.forClass(sourceClass);
        return RxJava1ResponseExtractors.body(bodyType);
    }

    public static <T> BodyExtractor<Single<T>> as(ResolvableType bodyType) {
        return (clientResponse, messageConverters) -> RxJava1Adapter.publisherToSingle(RxJava1ResponseExtractors.decodeResponseBodyAsMono(clientResponse, bodyType, messageConverters));
    }

    public static <T> BodyExtractor<Single<T>> as(Class<T> sourceClass) {
        ResolvableType bodyType = ResolvableType.forClass(sourceClass);
        return RxJava1ResponseExtractors.as(bodyType);
    }

    public static <T> ResponseExtractor<Observable<T>> bodyStream(ResolvableType bodyType) {
        return (clientResponse, webClientConfig) -> RxJava1Adapter.publisherToObservable((Publisher)clientResponse.doOnNext(response -> webClientConfig.getResponseErrorHandler().handleError((ClientHttpResponse)response, webClientConfig.getMessageReaders())).flatMap(resp -> RxJava1ResponseExtractors.decodeResponseBody(resp, bodyType, webClientConfig.getMessageReaders())));
    }

    public static <T> ResponseExtractor<Observable<T>> bodyStream(Class<T> sourceClass) {
        ResolvableType bodyType = ResolvableType.forClass(sourceClass);
        return RxJava1ResponseExtractors.bodyStream(bodyType);
    }

    public static <T> BodyExtractor<Observable<T>> asStream(ResolvableType bodyType) {
        return (clientResponse, messageConverters) -> RxJava1Adapter.publisherToObservable(RxJava1ResponseExtractors.decodeResponseBody(clientResponse, bodyType, messageConverters));
    }

    public static <T> BodyExtractor<Observable<T>> asStream(Class<T> sourceClass) {
        ResolvableType bodyType = ResolvableType.forClass(sourceClass);
        return RxJava1ResponseExtractors.asStream(bodyType);
    }

    public static <T> ResponseExtractor<Single<ResponseEntity<T>>> response(ResolvableType bodyType) {
        return (clientResponse, webClientConfig) -> RxJava1Adapter.publisherToSingle((Publisher)clientResponse.then(response -> Mono.when((Mono)RxJava1ResponseExtractors.decodeResponseBody(response, bodyType, webClientConfig.getMessageReaders()).next(), (Mono)Mono.just((Object)response.getHeaders()), (Mono)Mono.just((Object)((Object)response.getStatusCode())))).map(tuple -> new ResponseEntity<Object>(tuple.getT1(), (MultiValueMap<String, String>)((MultiValueMap)tuple.getT2()), (HttpStatus)((Object)((Object)((Object)tuple.getT3()))))));
    }

    public static <T> ResponseExtractor<Single<ResponseEntity<T>>> response(Class<T> sourceClass) {
        ResolvableType bodyType = ResolvableType.forClass(sourceClass);
        return RxJava1ResponseExtractors.response(bodyType);
    }

    public static <T> ResponseExtractor<Single<ResponseEntity<Observable<T>>>> responseStream(Class<T> sourceClass) {
        ResolvableType resolvableType = ResolvableType.forClass(sourceClass);
        return RxJava1ResponseExtractors.responseStream(resolvableType);
    }

    public static <T> ResponseExtractor<Single<ResponseEntity<Observable<T>>>> responseStream(ResolvableType bodyType) {
        return (clientResponse, webClientConfig) -> RxJava1Adapter.publisherToSingle((Publisher)clientResponse.map(response -> new ResponseEntity<Observable>(RxJava1Adapter.publisherToObservable(RxJava1ResponseExtractors.decodeResponseBody(response, bodyType, webClientConfig.getMessageReaders())), (MultiValueMap<String, String>)response.getHeaders(), response.getStatusCode())));
    }

    public static ResponseExtractor<Single<HttpHeaders>> headers() {
        return (clientResponse, messageConverters) -> RxJava1Adapter.publisherToSingle((Publisher)clientResponse.map(resp -> resp.getHeaders()));
    }

    protected static <T> Flux<T> decodeResponseBody(ClientHttpResponse response, ResolvableType responseType, List<HttpMessageReader<?>> messageReaders) {
        MediaType contentType = response.getHeaders().getContentType();
        HttpMessageReader<?> converter = RxJava1ResponseExtractors.resolveMessageReader(messageReaders, responseType, contentType);
        return converter.read(responseType, response, Collections.emptyMap());
    }

    protected static <T> Mono<T> decodeResponseBodyAsMono(ClientHttpResponse response, ResolvableType responseType, List<HttpMessageReader<?>> messageReaders) {
        MediaType contentType = response.getHeaders().getContentType();
        HttpMessageReader<?> converter = RxJava1ResponseExtractors.resolveMessageReader(messageReaders, responseType, contentType);
        return converter.readMono(responseType, response, Collections.emptyMap());
    }

    protected static HttpMessageReader<?> resolveMessageReader(List<HttpMessageReader<?>> messageReaders, ResolvableType responseType, MediaType contentType) {
        return messageReaders.stream().filter(e -> e.canRead(responseType, contentType)).findFirst().orElseThrow(() -> new WebClientException("Could not decode response body of type '" + contentType + "' with target type '" + responseType.toString() + "'"));
    }
}

