/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.server.WebExceptionHandler;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.adapter.HttpWebHandlerAdapter;
import org.springframework.web.server.handler.ExceptionHandlingWebHandler;
import org.springframework.web.server.handler.FilteringWebHandler;
import org.springframework.web.server.session.WebSessionManager;

public class WebHttpHandlerBuilder {
    private final WebHandler targetHandler;
    private final List<WebFilter> filters = new ArrayList<WebFilter>();
    private final List<WebExceptionHandler> exceptionHandlers = new ArrayList<WebExceptionHandler>();
    private WebSessionManager sessionManager;

    private WebHttpHandlerBuilder(WebHandler targetHandler) {
        Assert.notNull((Object)targetHandler, (String)"WebHandler must not be null");
        this.targetHandler = targetHandler;
    }

    public static WebHttpHandlerBuilder webHandler(WebHandler webHandler) {
        return new WebHttpHandlerBuilder(webHandler);
    }

    public WebHttpHandlerBuilder filters(WebFilter ... filters) {
        if (!ObjectUtils.isEmpty((Object[])filters)) {
            this.filters.addAll(Arrays.asList(filters));
        }
        return this;
    }

    public WebHttpHandlerBuilder exceptionHandlers(WebExceptionHandler ... exceptionHandlers) {
        if (!ObjectUtils.isEmpty((Object[])exceptionHandlers)) {
            this.exceptionHandlers.addAll(Arrays.asList(exceptionHandlers));
        }
        return this;
    }

    public WebHttpHandlerBuilder sessionManager(WebSessionManager sessionManager) {
        this.sessionManager = sessionManager;
        return this;
    }

    public HttpHandler build() {
        Object[] array;
        WebHandler webHandler = this.targetHandler;
        if (!this.filters.isEmpty()) {
            array = new WebFilter[this.filters.size()];
            webHandler = new FilteringWebHandler(webHandler, (WebFilter[])this.filters.toArray(array));
        }
        if (!this.exceptionHandlers.isEmpty()) {
            array = new WebExceptionHandler[this.exceptionHandlers.size()];
            webHandler = new ExceptionHandlingWebHandler(webHandler, (WebExceptionHandler[])this.exceptionHandlers.toArray(array));
        }
        HttpWebHandlerAdapter httpHandler = new HttpWebHandlerAdapter(webHandler);
        if (this.sessionManager != null) {
            httpHandler.setSessionManager(this.sessionManager);
        }
        return httpHandler;
    }
}

