/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.HttpChannel;

public class ReactorServerHttpResponse
extends AbstractServerHttpResponse
implements ZeroCopyHttpOutputMessage {
    private final HttpChannel channel;

    public ReactorServerHttpResponse(HttpChannel response, DataBufferFactory bufferFactory) {
        super(bufferFactory);
        Assert.notNull((Object)"'response' must not be null.");
        this.channel = response;
    }

    public HttpChannel getReactorChannel() {
        return this.channel;
    }

    @Override
    protected void applyStatusCode() {
        HttpStatus statusCode = this.getStatusCode();
        if (statusCode != null) {
            this.getReactorChannel().status(HttpResponseStatus.valueOf((int)statusCode.value()));
        }
    }

    @Override
    protected Mono<Void> writeWithInternal(Publisher<DataBuffer> publisher) {
        Publisher<ByteBuf> body = ReactorServerHttpResponse.toByteBufs(publisher);
        return this.channel.send(body);
    }

    @Override
    protected Mono<Void> writeAndFlushWithInternal(Publisher<Publisher<DataBuffer>> publisher) {
        Flux body = Flux.from(publisher).map(ReactorServerHttpResponse::toByteBufs);
        return this.channel.sendAndFlush((Publisher)body);
    }

    @Override
    protected void applyHeaders() {
        if (this.getHeaders().containsKey("Content-Length")) {
            this.channel.responseTransfer(false);
        }
        for (String name : this.getHeaders().keySet()) {
            Iterator iterator = this.getHeaders().get(name).iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                this.channel.responseHeaders().add(name, (Object)value);
            }
        }
    }

    @Override
    protected void applyCookies() {
        for (String name : this.getCookies().keySet()) {
            for (ResponseCookie httpCookie : (List)this.getCookies().get((Object)name)) {
                DefaultCookie cookie = new DefaultCookie(name, httpCookie.getValue());
                if (!httpCookie.getMaxAge().isNegative()) {
                    cookie.setMaxAge(httpCookie.getMaxAge().getSeconds());
                }
                httpCookie.getDomain().ifPresent(arg_0 -> ((Cookie)cookie).setDomain(arg_0));
                httpCookie.getPath().ifPresent(arg_0 -> ((Cookie)cookie).setPath(arg_0));
                cookie.setSecure(httpCookie.isSecure());
                cookie.setHttpOnly(httpCookie.isHttpOnly());
                this.channel.addResponseCookie((Cookie)cookie);
            }
        }
    }

    @Override
    public Mono<Void> writeWith(File file, long position, long count) {
        return this.doCommit(() -> this.channel.sendFile(file, position, count));
    }

    private static Publisher<ByteBuf> toByteBufs(Publisher<DataBuffer> dataBuffers) {
        return Flux.from(dataBuffers).map(NettyDataBufferFactory::toByteBuf);
    }
}

