/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.ResponseContentWriter;
import java.util.Iterator;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class RxNettyServerHttpResponse
extends AbstractServerHttpResponse {
    private final HttpServerResponse<ByteBuf> response;
    private static final ByteBuf FLUSH_SIGNAL = Unpooled.buffer((int)0, (int)0);

    public RxNettyServerHttpResponse(HttpServerResponse<ByteBuf> response, NettyDataBufferFactory dataBufferFactory) {
        super((DataBufferFactory)dataBufferFactory);
        Assert.notNull((Object)"'response', response must not be null.");
        this.response = response;
    }

    public HttpServerResponse<?> getRxNettyResponse() {
        return this.response;
    }

    @Override
    protected void applyStatusCode() {
        HttpStatus statusCode = this.getStatusCode();
        if (statusCode != null) {
            this.response.setStatus(HttpResponseStatus.valueOf((int)statusCode.value()));
        }
    }

    @Override
    protected Mono<Void> writeWithInternal(Publisher<DataBuffer> body) {
        Observable content = RxReactiveStreams.toObservable(body).map(NettyDataBufferFactory::toByteBuf);
        return Flux.from((Publisher)RxReactiveStreams.toPublisher((Observable)this.response.write(content))).then();
    }

    @Override
    protected Mono<Void> writeAndFlushWithInternal(Publisher<Publisher<DataBuffer>> body) {
        Flux bodyWithFlushSignals = Flux.from(body).flatMap(publisher -> Flux.from((Publisher)publisher).map(NettyDataBufferFactory::toByteBuf).concatWith((Publisher)Mono.just((Object)FLUSH_SIGNAL)));
        Observable content = RxReactiveStreams.toObservable((Publisher)bodyWithFlushSignals);
        ResponseContentWriter writer = this.response.write(content, bb -> bb == FLUSH_SIGNAL);
        return Flux.from((Publisher)RxReactiveStreams.toPublisher((Observable)writer)).then();
    }

    @Override
    protected void applyHeaders() {
        for (String name : this.getHeaders().keySet()) {
            Iterator iterator = this.getHeaders().get(name).iterator();
            while (iterator.hasNext()) {
                String value = (String)iterator.next();
                this.response.addHeader((CharSequence)name, (Object)value);
            }
        }
    }

    @Override
    protected void applyCookies() {
        for (String name : this.getCookies().keySet()) {
            for (ResponseCookie httpCookie : (List)this.getCookies().get((Object)name)) {
                DefaultCookie cookie = new DefaultCookie(name, httpCookie.getValue());
                if (!httpCookie.getMaxAge().isNegative()) {
                    cookie.setMaxAge(httpCookie.getMaxAge().getSeconds());
                }
                httpCookie.getDomain().ifPresent(arg_0 -> ((Cookie)cookie).setDomain(arg_0));
                httpCookie.getPath().ifPresent(arg_0 -> ((Cookie)cookie).setPath(arg_0));
                cookie.setSecure(httpCookie.isSecure());
                cookie.setHttpOnly(httpCookie.isHttpOnly());
                this.response.addCookie((Cookie)cookie);
            }
        }
    }
}

