/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.net.URI;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;

public class ServerHttpRequestDecorator
implements ServerHttpRequest {
    private final ServerHttpRequest delegate;

    public ServerHttpRequestDecorator(ServerHttpRequest delegate) {
        Assert.notNull((Object)delegate, (String)"'delegate' is required.");
        this.delegate = delegate;
    }

    public ServerHttpRequest getDelegate() {
        return this.delegate;
    }

    @Override
    public HttpMethod getMethod() {
        return this.getDelegate().getMethod();
    }

    @Override
    public URI getURI() {
        return this.getDelegate().getURI();
    }

    @Override
    public MultiValueMap<String, String> getQueryParams() {
        return this.getDelegate().getQueryParams();
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.getDelegate().getHeaders();
    }

    @Override
    public MultiValueMap<String, HttpCookie> getCookies() {
        return this.getDelegate().getCookies();
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.getDelegate().getBody();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [delegate=" + this.getDelegate() + "]";
    }
}

