/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.HttpHandlerAdapterSupport;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.util.Assert;

@WebServlet(asyncSupported=true)
public class ServletHttpHandlerAdapter
extends HttpHandlerAdapterSupport
implements Servlet {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private DataBufferFactory dataBufferFactory = new DefaultDataBufferFactory(false);
    private int bufferSize = 8192;

    public ServletHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    public ServletHttpHandlerAdapter(Map<String, HttpHandler> handlerMap) {
        super(handlerMap);
    }

    public void setDataBufferFactory(DataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)dataBufferFactory, (String)"'dataBufferFactory' must not be null");
        this.dataBufferFactory = dataBufferFactory;
    }

    public DataBufferFactory getDataBufferFactory() {
        return this.dataBufferFactory;
    }

    public void setBufferSize(int bufferSize) {
        Assert.isTrue((bufferSize > 0 ? 1 : 0) != 0);
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException {
        AsyncContext asyncContext = servletRequest.startAsync();
        ServletServerHttpRequest request = new ServletServerHttpRequest((HttpServletRequest)servletRequest, this.getDataBufferFactory(), this.getBufferSize());
        ServletServerHttpResponse response = new ServletServerHttpResponse((HttpServletResponse)servletResponse, this.getDataBufferFactory(), this.getBufferSize());
        asyncContext.addListener((AsyncListener)new EventHandlingAsyncListener(request, response));
        HandlerResultSubscriber resultSubscriber = new HandlerResultSubscriber(asyncContext);
        this.getHttpHandler().handle(request, response).subscribe((Subscriber)resultSubscriber);
    }

    public void init(ServletConfig config) {
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public String getServletInfo() {
        return "";
    }

    public void destroy() {
    }

    private static final class EventHandlingAsyncListener
    implements AsyncListener {
        private final ServletServerHttpRequest request;
        private final ServletServerHttpResponse response;

        public EventHandlingAsyncListener(ServletServerHttpRequest request, ServletServerHttpResponse response) {
            this.request = request;
            this.response = response;
        }

        public void onTimeout(AsyncEvent event) {
            Throwable ex = event.getThrowable();
            if (ex == null) {
                ex = new IllegalStateException("Async operation timeout.");
            }
            this.request.handleAsyncListenerError(ex);
            this.response.handleAsyncListenerError(ex);
        }

        public void onError(AsyncEvent event) {
            this.request.handleAsyncListenerError(event.getThrowable());
            this.response.handleAsyncListenerError(event.getThrowable());
        }

        public void onStartAsync(AsyncEvent event) {
        }

        public void onComplete(AsyncEvent event) {
            this.request.handleAsyncListenerComplete();
            this.response.handleAsyncListenerComplete();
        }
    }

    private class HandlerResultSubscriber
    implements Subscriber<Void> {
        private final AsyncContext asyncContext;

        public HandlerResultSubscriber(AsyncContext asyncContext) {
            this.asyncContext = asyncContext;
        }

        public void onSubscribe(Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(Void aVoid) {
        }

        public void onError(Throwable ex) {
            ServletHttpHandlerAdapter.this.logger.error((Object)"Could not complete request", ex);
            HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
            response.setStatus(500);
            this.asyncContext.complete();
        }

        public void onComplete() {
            ServletHttpHandlerAdapter.this.logger.debug((Object)"Successfully completed request");
            this.asyncContext.complete();
        }
    }
}

