/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server.session;

import java.time.Clock;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import org.springframework.util.Assert;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.session.ConfigurableWebSession;
import org.springframework.web.server.session.CookieWebSessionIdResolver;
import org.springframework.web.server.session.DefaultWebSession;
import org.springframework.web.server.session.InMemoryWebSessionStore;
import org.springframework.web.server.session.WebSessionIdResolver;
import org.springframework.web.server.session.WebSessionManager;
import org.springframework.web.server.session.WebSessionStore;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DefaultWebSessionManager
implements WebSessionManager {
    private WebSessionIdResolver sessionIdResolver = new CookieWebSessionIdResolver();
    private WebSessionStore sessionStore = new InMemoryWebSessionStore();
    private Clock clock = Clock.systemDefaultZone();

    public void setSessionIdResolver(WebSessionIdResolver sessionIdResolver) {
        Assert.notNull((Object)sessionIdResolver, (String)"'sessionIdResolver' is required.");
        this.sessionIdResolver = sessionIdResolver;
    }

    public WebSessionIdResolver getSessionIdResolver() {
        return this.sessionIdResolver;
    }

    public void setSessionStore(WebSessionStore sessionStore) {
        Assert.notNull((Object)sessionStore, (String)"'sessionStore' is required.");
        this.sessionStore = sessionStore;
    }

    public WebSessionStore getSessionStore() {
        return this.sessionStore;
    }

    public void setClock(Clock clock) {
        Assert.notNull((Object)clock, (String)"'clock' is required.");
        this.clock = clock;
    }

    public Clock getClock() {
        return this.clock;
    }

    @Override
    public Mono<WebSession> getSession(ServerWebExchange exchange) {
        return Mono.defer(() -> Flux.fromIterable(this.getSessionIdResolver().resolveSessionIds(exchange)).concatMap(this.sessionStore::retrieveSession).next().then(session -> this.validateSession(exchange, (WebSession)session)).otherwiseIfEmpty(this.createSession(exchange)).map(session -> this.extendSession(exchange, (WebSession)session)));
    }

    protected Mono<WebSession> validateSession(ServerWebExchange exchange, WebSession session) {
        if (session.isExpired()) {
            this.sessionIdResolver.setSessionId(exchange, "");
            return this.sessionStore.removeSession(session.getId()).cast(WebSession.class);
        }
        return Mono.just((Object)session);
    }

    protected Mono<WebSession> createSession(ServerWebExchange exchange) {
        String sessionId = UUID.randomUUID().toString();
        DefaultWebSession session = new DefaultWebSession(sessionId, this.getClock());
        return Mono.just((Object)session);
    }

    protected WebSession extendSession(ServerWebExchange exchange, WebSession session) {
        if (session instanceof ConfigurableWebSession) {
            ConfigurableWebSession managed = (ConfigurableWebSession)session;
            managed.setSaveOperation(() -> this.saveSession(exchange, session));
            managed.setLastAccessTime(Instant.now(this.getClock()));
        }
        exchange.getResponse().beforeCommit(session::save);
        return session;
    }

    protected Mono<Void> saveSession(ServerWebExchange exchange, WebSession session) {
        if (session.isExpired()) {
            return Mono.error((Throwable)new IllegalStateException("Sessions are checked for expiration and have their access time updated when first accessed during request processing. However this session is expired meaning that maxIdleTime elapsed since then and before the call to session.save()."));
        }
        if (!session.isStarted()) {
            return Mono.empty();
        }
        session.start();
        List<String> requestedIds = this.getSessionIdResolver().resolveSessionIds(exchange);
        if (requestedIds.isEmpty() || !session.getId().equals(requestedIds.get(0))) {
            this.sessionIdResolver.setSessionId(exchange, session.getId());
        }
        return this.sessionStore.storeSession(session);
    }
}

