/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriUtils;

public class HttpRequestPathHelper {
    private boolean urlDecode = true;

    public void setUrlDecode(boolean urlDecode) {
        this.urlDecode = urlDecode;
    }

    public boolean shouldUrlDecode() {
        return this.urlDecode;
    }

    public String getLookupPathForRequest(ServerWebExchange exchange) {
        String path = this.getPathWithinApplication(exchange.getRequest());
        return this.shouldUrlDecode() ? this.decode(exchange, path) : path;
    }

    private String getPathWithinApplication(ServerHttpRequest request) {
        String contextPath = request.getContextPath();
        String path = request.getURI().getRawPath();
        if (!StringUtils.hasText((String)contextPath)) {
            return path;
        }
        int contextLength = contextPath.length();
        return path.length() > contextLength ? path.substring(contextLength) : "";
    }

    private String decode(ServerWebExchange exchange, String path) {
        try {
            return UriUtils.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Could not decode request string [" + path + "]");
        }
    }

    public Map<String, String> decodePathVariables(ServerWebExchange exchange, Map<String, String> vars) {
        if (this.urlDecode) {
            return vars;
        }
        LinkedHashMap<String, String> decodedVars = new LinkedHashMap<String, String>(vars.size());
        for (Map.Entry<String, String> entry : vars.entrySet()) {
            decodedVars.put(entry.getKey(), this.decode(exchange, entry.getValue()));
        }
        return decodedVars;
    }

    public MultiValueMap<String, String> decodeMatrixVariables(ServerWebExchange exchange, MultiValueMap<String, String> vars) {
        if (this.urlDecode) {
            return vars;
        }
        LinkedMultiValueMap decodedVars = new LinkedMultiValueMap(vars.size());
        for (String key : vars.keySet()) {
            for (String value : (List)vars.get((Object)key)) {
                decodedVars.add((Object)key, (Object)this.decode(exchange, value));
            }
        }
        return decodedVars;
    }
}

