/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.http.client.reactive.ReactorClientHttpRequest;
import org.springframework.http.client.reactive.ReactorClientHttpResponse;
import reactor.core.publisher.Mono;
import reactor.ipc.netty.http.client.HttpClient;
import reactor.ipc.netty.http.client.HttpClientOptions;
import reactor.ipc.netty.http.client.HttpClientRequest;

public class ReactorClientHttpConnector
implements ClientHttpConnector {
    private final HttpClient httpClient;

    public ReactorClientHttpConnector() {
        this.httpClient = HttpClient.create();
    }

    public ReactorClientHttpConnector(Consumer<? super HttpClientOptions> clientOptions) {
        this.httpClient = HttpClient.create(clientOptions);
    }

    @Override
    public Mono<ClientHttpResponse> connect(HttpMethod method, URI uri, Function<? super ClientHttpRequest, Mono<Void>> requestCallback) {
        return this.httpClient.request(io.netty.handler.codec.http.HttpMethod.valueOf((String)method.name()), uri.toString(), httpClientRequest -> (Mono)requestCallback.apply(new ReactorClientHttpRequest(method, uri, (HttpClientRequest)httpClientRequest))).map(ReactorClientHttpResponse::new);
    }
}

