/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import com.fasterxml.jackson.annotation.JsonView;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.Encoder;
import org.springframework.http.MediaType;
import org.springframework.http.codec.AbstractServerHttpMessageWriter;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.json.AbstractJackson2Codec;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class Jackson2ServerHttpMessageWriter
extends AbstractServerHttpMessageWriter<Object> {
    public Jackson2ServerHttpMessageWriter(Encoder<Object> encoder) {
        super(new EncoderHttpMessageWriter<Object>(encoder));
    }

    public Jackson2ServerHttpMessageWriter(HttpMessageWriter<Object> writer) {
        super(writer);
    }

    @Override
    protected Map<String, Object> resolveWriteHints(ResolvableType streamType, ResolvableType elementType, MediaType mediaType, ServerHttpRequest request) {
        JsonView annotation;
        MethodParameter returnValue;
        HashMap<String, Object> hints = new HashMap<String, Object>();
        Object source = streamType.getSource();
        MethodParameter methodParameter = returnValue = source instanceof MethodParameter ? (MethodParameter)source : null;
        if (returnValue != null && (annotation = (JsonView)returnValue.getMethodAnnotation(JsonView.class)) != null) {
            Class[] classes = annotation.value();
            if (classes.length != 1) {
                throw new IllegalArgumentException("@JsonView only supported for write hints with exactly 1 class argument: " + returnValue);
            }
            hints.put(AbstractJackson2Codec.JSON_VIEW_HINT, classes[0]);
        }
        return hints;
    }
}

