/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.converter.protobuf;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.util.JsonFormat;
import com.googlecode.protobuf.format.FormatFactory;
import com.googlecode.protobuf.format.ProtobufFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.protobuf.ExtensionRegistryInitializer;
import org.springframework.util.ClassUtils;

public class ProtobufHttpMessageConverter
extends AbstractHttpMessageConverter<Message> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final MediaType PROTOBUF = new MediaType("application", "x-protobuf", DEFAULT_CHARSET);
    public static final String X_PROTOBUF_SCHEMA_HEADER = "X-Protobuf-Schema";
    public static final String X_PROTOBUF_MESSAGE_HEADER = "X-Protobuf-Message";
    private static final boolean isProtobufJavaUtilPresent = ClassUtils.isPresent((String)"com.google.protobuf.util.JsonFormat", (ClassLoader)ProtobufHttpMessageConverter.class.getClassLoader());
    private static final boolean isProtobufJavaFormatPresent = ClassUtils.isPresent((String)"com.googlecode.protobuf.format.JsonFormat", (ClassLoader)ProtobufHttpMessageConverter.class.getClassLoader());
    private static final MediaType[] SUPPORTED_MEDIATYPES;
    private final ProtobufFormatsSupport protobufFormatsSupport;
    private static final ConcurrentHashMap<Class<?>, Method> methodCache;
    private final ExtensionRegistry extensionRegistry = ExtensionRegistry.newInstance();

    public ProtobufHttpMessageConverter() {
        this((ExtensionRegistryInitializer)null);
    }

    public ProtobufHttpMessageConverter(ExtensionRegistryInitializer registryInitializer) {
        super(SUPPORTED_MEDIATYPES);
        this.protobufFormatsSupport = isProtobufJavaFormatPresent ? new ProtobufJavaFormatSupport() : (isProtobufJavaUtilPresent ? new ProtobufJavaUtilSupport() : null);
        if (registryInitializer != null) {
            registryInitializer.initializeExtensionRegistry(this.extensionRegistry);
        }
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return Message.class.isAssignableFrom(clazz);
    }

    @Override
    protected MediaType getDefaultContentType(Message message) {
        return PROTOBUF;
    }

    @Override
    protected Message readInternal(Class<? extends Message> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Charset charset;
        MediaType contentType = inputMessage.getHeaders().getContentType();
        if (contentType == null) {
            contentType = PROTOBUF;
        }
        if ((charset = contentType.getCharset()) == null) {
            charset = DEFAULT_CHARSET;
        }
        try {
            Message.Builder builder = ProtobufHttpMessageConverter.getMessageBuilder(clazz);
            if (PROTOBUF.isCompatibleWith(contentType)) {
                builder.mergeFrom(inputMessage.getBody(), (ExtensionRegistryLite)this.extensionRegistry);
            } else if (MediaType.TEXT_PLAIN.isCompatibleWith(contentType)) {
                InputStreamReader reader = new InputStreamReader(inputMessage.getBody(), charset);
                TextFormat.merge((Readable)reader, (ExtensionRegistry)this.extensionRegistry, (Message.Builder)builder);
            } else if (isProtobufJavaUtilPresent || isProtobufJavaFormatPresent) {
                this.protobufFormatsSupport.merge(inputMessage.getBody(), charset, contentType, this.extensionRegistry, builder);
            }
            return builder.build();
        }
        catch (Exception ex) {
            throw new HttpMessageNotReadableException("Could not read Protobuf message: " + ex.getMessage(), ex);
        }
    }

    @Override
    protected boolean canWrite(MediaType mediaType) {
        return super.canWrite(mediaType) || isProtobufJavaFormatPresent && MediaType.TEXT_HTML.isCompatibleWith(mediaType);
    }

    @Override
    protected void writeInternal(Message message, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        Charset charset;
        MediaType contentType = outputMessage.getHeaders().getContentType();
        if (contentType == null) {
            contentType = this.getDefaultContentType(message);
        }
        if ((charset = contentType.getCharset()) == null) {
            charset = DEFAULT_CHARSET;
        }
        if (PROTOBUF.isCompatibleWith(contentType)) {
            this.setProtoHeader(outputMessage, message);
            CodedOutputStream codedOutputStream = CodedOutputStream.newInstance((OutputStream)outputMessage.getBody());
            message.writeTo(codedOutputStream);
            codedOutputStream.flush();
        } else if (MediaType.TEXT_PLAIN.isCompatibleWith(contentType)) {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputMessage.getBody(), charset);
            TextFormat.print((MessageOrBuilder)message, (Appendable)outputStreamWriter);
            outputStreamWriter.flush();
            outputMessage.getBody().flush();
        } else if (isProtobufJavaUtilPresent || isProtobufJavaFormatPresent) {
            this.protobufFormatsSupport.print(message, outputMessage.getBody(), contentType, charset);
            outputMessage.getBody().flush();
        }
    }

    private void setProtoHeader(HttpOutputMessage response, Message message) {
        response.getHeaders().set(X_PROTOBUF_SCHEMA_HEADER, message.getDescriptorForType().getFile().getName());
        response.getHeaders().set(X_PROTOBUF_MESSAGE_HEADER, message.getDescriptorForType().getFullName());
    }

    private static Message.Builder getMessageBuilder(Class<? extends Message> clazz) throws Exception {
        Method method = methodCache.get(clazz);
        if (method == null) {
            method = clazz.getMethod("newBuilder", new Class[0]);
            methodCache.put(clazz, method);
        }
        return (Message.Builder)method.invoke(clazz, new Object[0]);
    }

    static {
        methodCache = new ConcurrentHashMap();
        SUPPORTED_MEDIATYPES = isProtobufJavaFormatPresent ? new MediaType[]{PROTOBUF, MediaType.TEXT_PLAIN, MediaType.APPLICATION_XML, MediaType.APPLICATION_JSON} : (isProtobufJavaUtilPresent ? new MediaType[]{PROTOBUF, MediaType.TEXT_PLAIN, MediaType.APPLICATION_JSON} : new MediaType[]{PROTOBUF, MediaType.TEXT_PLAIN});
    }

    private class ProtobufJavaFormatSupport
    implements ProtobufFormatsSupport {
        private final FormatFactory FORMAT_FACTORY = new FormatFactory();
        private final ProtobufFormatter JSON_FORMATTER = this.FORMAT_FACTORY.createFormatter(FormatFactory.Formatter.JSON);
        private final ProtobufFormatter XML_FORMATTER = this.FORMAT_FACTORY.createFormatter(FormatFactory.Formatter.XML);
        private final ProtobufFormatter HTML_FORMATTER = this.FORMAT_FACTORY.createFormatter(FormatFactory.Formatter.HTML);

        @Override
        public void merge(InputStream input, Charset cs, MediaType contentType, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
            if (contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                this.JSON_FORMATTER.merge(input, cs, extensionRegistry, builder);
            } else if (contentType.isCompatibleWith(MediaType.APPLICATION_XML)) {
                this.XML_FORMATTER.merge(input, cs, extensionRegistry, builder);
            } else {
                throw new UnsupportedOperationException("com.google.protobuf.util does not support " + contentType.toString() + " format");
            }
        }

        @Override
        public void print(Message message, OutputStream output, MediaType contentType, Charset cs) throws IOException {
            if (contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                this.JSON_FORMATTER.print(message, output, cs);
            } else if (contentType.isCompatibleWith(MediaType.APPLICATION_XML)) {
                this.XML_FORMATTER.print(message, output, cs);
            } else if (contentType.isCompatibleWith(MediaType.TEXT_HTML)) {
                this.HTML_FORMATTER.print(message, output, cs);
            } else {
                throw new UnsupportedOperationException("com.google.protobuf.util does not support " + contentType.toString() + " format");
            }
        }
    }

    private class ProtobufJavaUtilSupport
    implements ProtobufFormatsSupport {
        private final JsonFormat.Parser parser = JsonFormat.parser();
        private final JsonFormat.Printer printer = JsonFormat.printer();

        @Override
        public void merge(InputStream input, Charset cs, MediaType contentType, ExtensionRegistry extensionRegistry, Message.Builder builder) throws IOException {
            if (!contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                throw new UnsupportedOperationException("com.googlecode.protobuf:protobuf-java-util does not support " + contentType.toString() + " format");
            }
            InputStreamReader reader = new InputStreamReader(input, cs);
            this.parser.merge((Reader)reader, builder);
        }

        @Override
        public void print(Message message, OutputStream output, MediaType contentType, Charset cs) throws IOException {
            if (!contentType.isCompatibleWith(MediaType.APPLICATION_JSON)) {
                throw new UnsupportedOperationException("com.googlecode.protobuf:protobuf-java-util does not support " + contentType.toString() + " format");
            }
            this.printer.appendTo((MessageOrBuilder)message, (Appendable)new OutputStreamWriter(output, cs));
        }
    }

    private static interface ProtobufFormatsSupport {
        public void merge(InputStream var1, Charset var2, MediaType var3, ExtensionRegistry var4, Message.Builder var5) throws IOException;

        public void print(Message var1, OutputStream var2, MediaType var3, Charset var4) throws IOException;
    }
}

