/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Operators;

public abstract class AbstractListenerReadPublisher<T>
implements Publisher<T> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final AtomicReference<State> state = new AtomicReference<State>(State.UNSUBSCRIBED);
    private final AtomicLong demand = new AtomicLong();
    private Subscriber<? super T> subscriber;

    public void subscribe(Subscriber<? super T> subscriber) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " subscribe: " + subscriber));
        }
        this.state.get().subscribe(this, subscriber);
    }

    public final void onDataAvailable() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onDataAvailable"));
        }
        this.state.get().onDataAvailable(this);
    }

    public void onAllDataRead() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)(this.state + " onAllDataRead"));
        }
        this.state.get().onAllDataRead(this);
    }

    public final void onError(Throwable t) {
        if (this.logger.isErrorEnabled()) {
            this.logger.error((Object)(this.state + " onError: " + t), t);
        }
        this.state.get().onError(this, t);
    }

    protected abstract void checkOnDataAvailable();

    protected abstract T read() throws IOException;

    private boolean readAndPublish() throws IOException {
        while (this.hasDemand()) {
            T data = this.read();
            if (data != null) {
                AbstractListenerReadPublisher.getAndSub(this.demand, 1L);
                this.subscriber.onNext(data);
                continue;
            }
            return true;
        }
        return false;
    }

    private static long getAndSub(AtomicLong sequence, long toSub) {
        long u;
        long r;
        do {
            if ((r = sequence.get()) != 0L && r != Long.MAX_VALUE) continue;
            return r;
        } while (!sequence.compareAndSet(r, u = Operators.subOrZero((long)r, (long)toSub)));
        return r;
    }

    private boolean hasDemand() {
        return this.demand.get() > 0L;
    }

    private boolean changeState(State oldState, State newState) {
        return this.state.compareAndSet(oldState, newState);
    }

    private static enum State {
        UNSUBSCRIBED{

            @Override
            <T> void subscribe(AbstractListenerReadPublisher<T> publisher, Subscriber<? super T> subscriber) {
                Objects.requireNonNull(subscriber);
                if (!((AbstractListenerReadPublisher)publisher).changeState(this, 1.NO_DEMAND)) {
                    throw new IllegalStateException(this.toString());
                }
                ReadSubscription subscription = new ReadSubscription(publisher);
                ((AbstractListenerReadPublisher)publisher).subscriber = subscriber;
                subscriber.onSubscribe((Subscription)subscription);
            }
        }
        ,
        NO_DEMAND{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
                if (Operators.checkRequest((long)n, (Subscriber)((AbstractListenerReadPublisher)publisher).subscriber)) {
                    Operators.addAndGet((AtomicLong)((AbstractListenerReadPublisher)publisher).demand, (long)n);
                    if (((AbstractListenerReadPublisher)publisher).changeState(this, 2.DEMAND)) {
                        publisher.checkOnDataAvailable();
                    }
                }
            }
        }
        ,
        DEMAND{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
                if (Operators.checkRequest((long)n, (Subscriber)((AbstractListenerReadPublisher)publisher).subscriber)) {
                    Operators.addAndGet((AtomicLong)((AbstractListenerReadPublisher)publisher).demand, (long)n);
                }
            }

            @Override
            <T> void onDataAvailable(AbstractListenerReadPublisher<T> publisher) {
                if (((AbstractListenerReadPublisher)publisher).changeState(this, 3.READING)) {
                    try {
                        boolean demandAvailable = ((AbstractListenerReadPublisher)publisher).readAndPublish();
                        if (demandAvailable) {
                            ((AbstractListenerReadPublisher)publisher).changeState(3.READING, 3.DEMAND);
                            publisher.checkOnDataAvailable();
                        } else {
                            ((AbstractListenerReadPublisher)publisher).changeState(3.READING, 3.NO_DEMAND);
                        }
                    }
                    catch (IOException ex) {
                        publisher.onError(ex);
                    }
                }
            }
        }
        ,
        READING{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
                if (Operators.checkRequest((long)n, (Subscriber)((AbstractListenerReadPublisher)publisher).subscriber)) {
                    Operators.addAndGet((AtomicLong)((AbstractListenerReadPublisher)publisher).demand, (long)n);
                }
            }
        }
        ,
        COMPLETED{

            @Override
            <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
            }

            @Override
            <T> void cancel(AbstractListenerReadPublisher<T> publisher) {
            }

            @Override
            <T> void onAllDataRead(AbstractListenerReadPublisher<T> publisher) {
            }

            @Override
            <T> void onError(AbstractListenerReadPublisher<T> publisher, Throwable t) {
            }
        };


        <T> void subscribe(AbstractListenerReadPublisher<T> publisher, Subscriber<? super T> subscriber) {
            throw new IllegalStateException(this.toString());
        }

        <T> void request(AbstractListenerReadPublisher<T> publisher, long n) {
            throw new IllegalStateException(this.toString());
        }

        <T> void cancel(AbstractListenerReadPublisher<T> publisher) {
            ((AbstractListenerReadPublisher)publisher).changeState(this, State.COMPLETED);
        }

        <T> void onDataAvailable(AbstractListenerReadPublisher<T> publisher) {
        }

        <T> void onAllDataRead(AbstractListenerReadPublisher<T> publisher) {
            if (((AbstractListenerReadPublisher)publisher).changeState(this, State.COMPLETED) && ((AbstractListenerReadPublisher)publisher).subscriber != null) {
                ((AbstractListenerReadPublisher)publisher).subscriber.onComplete();
            }
        }

        <T> void onError(AbstractListenerReadPublisher<T> publisher, Throwable t) {
            if (((AbstractListenerReadPublisher)publisher).changeState(this, State.COMPLETED) && ((AbstractListenerReadPublisher)publisher).subscriber != null) {
                ((AbstractListenerReadPublisher)publisher).subscriber.onError(t);
            }
        }
    }

    private static final class ReadSubscription
    implements Subscription {
        private final AbstractListenerReadPublisher<?> publisher;

        public ReadSubscription(AbstractListenerReadPublisher<?> publisher) {
            this.publisher = publisher;
        }

        public final void request(long n) {
            if (this.publisher.logger.isTraceEnabled()) {
                this.publisher.logger.trace((Object)((Object)((Object)this.state()) + " request: " + n));
            }
            this.state().request(this.publisher, n);
        }

        public final void cancel() {
            if (this.publisher.logger.isTraceEnabled()) {
                this.publisher.logger.trace((Object)((Object)((Object)this.state()) + " cancel"));
            }
            this.state().cancel(this.publisher);
        }

        private State state() {
            return (State)((Object)((AbstractListenerReadPublisher)this.publisher).state.get());
        }
    }
}

