/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.handler.codec.http.cookie.Cookie;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpCookie;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.ipc.netty.http.server.HttpServerRequest;

public class ReactorServerHttpRequest
extends AbstractServerHttpRequest {
    private final HttpServerRequest request;
    private final NettyDataBufferFactory bufferFactory;

    public ReactorServerHttpRequest(HttpServerRequest request, NettyDataBufferFactory bufferFactory) {
        super(ReactorServerHttpRequest.initUri(request), ReactorServerHttpRequest.initHeaders(request));
        Assert.notNull((Object)bufferFactory, (String)"'bufferFactory' must not be null");
        this.request = request;
        this.bufferFactory = bufferFactory;
    }

    private static URI initUri(HttpServerRequest channel) {
        Assert.notNull((Object)"'channel' must not be null");
        try {
            URI uri = new URI(channel.uri());
            InetSocketAddress remoteAddress = channel.remoteAddress();
            return new URI(uri.getScheme(), uri.getUserInfo(), remoteAddress != null ? remoteAddress.getHostString() : null, remoteAddress != null ? remoteAddress.getPort() : -1, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            throw new IllegalStateException("Could not get URI: " + ex.getMessage(), ex);
        }
    }

    private static HttpHeaders initHeaders(HttpServerRequest channel) {
        HttpHeaders headers = new HttpHeaders();
        for (String name : channel.requestHeaders().names()) {
            headers.put(name, channel.requestHeaders().getAll(name));
        }
        return headers;
    }

    public HttpServerRequest getReactorRequest() {
        return this.request;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.request.method().name());
    }

    @Override
    protected MultiValueMap<String, HttpCookie> initCookies() {
        LinkedMultiValueMap cookies = new LinkedMultiValueMap();
        for (CharSequence name : this.request.cookies().keySet()) {
            for (Cookie cookie : (Set)this.request.cookies().get(name)) {
                HttpCookie httpCookie = new HttpCookie(name.toString(), cookie.value());
                cookies.add((Object)name.toString(), (Object)httpCookie);
            }
        }
        return cookies;
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.request.receive().retain().map(arg_0 -> ((NettyDataBufferFactory)this.bufferFactory).wrap(arg_0));
    }
}

