/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.HttpHandlerAdapterSupport;
import org.springframework.http.server.reactive.RxNettyServerHttpRequest;
import org.springframework.http.server.reactive.RxNettyServerHttpResponse;
import reactor.core.publisher.Mono;
import rx.Observable;
import rx.RxReactiveStreams;

public class RxNettyHttpHandlerAdapter
extends HttpHandlerAdapterSupport
implements RequestHandler<ByteBuf, ByteBuf> {
    public RxNettyHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    public RxNettyHttpHandlerAdapter(Map<String, HttpHandler> handlerMap) {
        super(handlerMap);
    }

    public Observable<Void> handle(HttpServerRequest<ByteBuf> nativeRequest, HttpServerResponse<ByteBuf> nativeResponse) {
        ByteBufAllocator allocator = nativeResponse.unsafeNettyChannel().alloc();
        NettyDataBufferFactory bufferFactory = new NettyDataBufferFactory(allocator);
        RxNettyServerHttpRequest request = new RxNettyServerHttpRequest(nativeRequest, bufferFactory);
        RxNettyServerHttpResponse response = new RxNettyServerHttpResponse(nativeResponse, bufferFactory);
        Mono result = this.getHttpHandler().handle(request, response).otherwise(ex -> {
            this.logger.error((Object)"Could not complete request", ex);
            nativeResponse.setStatus(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            return Mono.empty();
        }).doOnSuccess(aVoid -> this.logger.debug((Object)"Successfully completed request"));
        return RxReactiveStreams.toObservable((Publisher)result);
    }
}

