/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http;

import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ContentDisposition {
    private final String type;
    private final String name;
    private final String filename;
    private final Charset charset;
    private final Long size;

    private ContentDisposition(String type, String name, String filename, Charset charset, Long size) {
        this.type = type;
        this.name = name;
        this.filename = filename;
        this.charset = charset;
        this.size = size;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getFilename() {
        return this.filename;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public Long getSize() {
        return this.size;
    }

    public static Builder builder(String type) {
        return new BuilderImpl(type);
    }

    public static ContentDisposition empty() {
        return new ContentDisposition(null, null, null, null, null);
    }

    public static ContentDisposition parse(String contentDisposition) {
        String[] parts = StringUtils.tokenizeToStringArray((String)contentDisposition, (String)";");
        Assert.isTrue((parts.length >= 1 ? 1 : 0) != 0, (String)"Content-Disposition header must not be empty");
        String type = parts[0];
        String name = null;
        String filename = null;
        Charset charset = null;
        Long size = null;
        for (int i = 1; i < parts.length; ++i) {
            String part = parts[i];
            int eqIndex = part.indexOf(61);
            if (eqIndex != -1) {
                String value;
                String attribute = part.substring(0, eqIndex);
                String string = value = part.startsWith("\"", eqIndex + 1) && part.endsWith("\"") ? part.substring(eqIndex + 2, part.length() - 1) : part.substring(eqIndex + 1, part.length());
                if (attribute.equals("name")) {
                    name = value;
                    continue;
                }
                if (attribute.equals("filename*")) {
                    filename = ContentDisposition.decodeHeaderFieldParam(value);
                    charset = Charset.forName(value.substring(0, value.indexOf("'")));
                    Assert.isTrue((StandardCharsets.UTF_8.equals(charset) || StandardCharsets.ISO_8859_1.equals(charset) ? 1 : 0) != 0, (String)"Charset should be UTF-8 or ISO-8859-1");
                    continue;
                }
                if (attribute.equals("filename") && filename == null) {
                    filename = value;
                    continue;
                }
                if (!attribute.equals("size")) continue;
                size = Long.parseLong(value);
                continue;
            }
            throw new IllegalArgumentException("Invalid content disposition format");
        }
        return new ContentDisposition(type, name, filename, charset, size);
    }

    private static String decodeHeaderFieldParam(String input) {
        Assert.notNull((Object)input, (String)"Input String should not be null");
        int firstQuoteIndex = input.indexOf("'");
        int secondQuoteIndex = input.indexOf("'", firstQuoteIndex + 1);
        if (firstQuoteIndex == -1 || secondQuoteIndex == -1) {
            return input;
        }
        Charset charset = Charset.forName(input.substring(0, firstQuoteIndex));
        Assert.isTrue((StandardCharsets.UTF_8.equals(charset) || StandardCharsets.ISO_8859_1.equals(charset) ? 1 : 0) != 0, (String)"Charset should be UTF-8 or ISO-8859-1");
        byte[] value = input.substring(secondQuoteIndex + 1, input.length()).getBytes(charset);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int index = 0;
        while (index < value.length) {
            byte b = value[index];
            if (ContentDisposition.isRFC5987AttrChar(b)) {
                bos.write((char)b);
                ++index;
                continue;
            }
            if (b == 37) {
                char[] array = new char[]{(char)value[index + 1], (char)value[index + 2]};
                bos.write(Integer.parseInt(String.valueOf(array), 16));
                index += 3;
                continue;
            }
            throw new IllegalArgumentException("Invalid header field parameter format (as defined in RFC 5987)");
        }
        return new String(bos.toByteArray(), charset);
    }

    private static boolean isRFC5987AttrChar(byte c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 122 || c >= 65 && c <= 90 || c == 33 || c == 35 || c == 36 || c == 38 || c == 43 || c == 45 || c == 46 || c == 94 || c == 95 || c == 96 || c == 124 || c == 126;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContentDisposition that = (ContentDisposition)o;
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.filename != null ? !this.filename.equals(that.filename) : that.filename != null) {
            return false;
        }
        if (this.charset != null ? !this.charset.equals(that.charset) : that.charset != null) {
            return false;
        }
        return this.size != null ? this.size.equals(that.size) : that.size == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.filename != null ? this.filename.hashCode() : 0);
        result = 31 * result + (this.charset != null ? this.charset.hashCode() : 0);
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.type);
        if (this.name != null) {
            builder.append("; name=\"");
            builder.append(this.name).append('\"');
        }
        if (this.filename != null) {
            if (this.charset == null || StandardCharsets.US_ASCII.equals(this.charset)) {
                builder.append("; filename=\"");
                builder.append(this.filename).append('\"');
            } else {
                builder.append("; filename*=");
                builder.append(ContentDisposition.encodeHeaderFieldParam(this.filename, this.charset));
            }
        }
        if (this.size != null) {
            builder.append("; size=");
            builder.append(this.size);
        }
        return builder.toString();
    }

    private static String encodeHeaderFieldParam(String input, Charset charset) {
        Assert.notNull((Object)input, (String)"Input String should not be null");
        Assert.notNull((Object)charset, (String)"Charset should not be null");
        if (StandardCharsets.US_ASCII.equals(charset)) {
            return input;
        }
        Assert.isTrue((StandardCharsets.UTF_8.equals(charset) || StandardCharsets.ISO_8859_1.equals(charset) ? 1 : 0) != 0, (String)"Charset should be UTF-8 or ISO-8859-1");
        byte[] source = input.getBytes(charset);
        int len = source.length;
        StringBuilder sb = new StringBuilder(len << 1);
        sb.append(charset.name());
        sb.append("''");
        for (byte b : source) {
            if (ContentDisposition.isRFC5987AttrChar(b)) {
                sb.append((char)b);
                continue;
            }
            sb.append('%');
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            sb.append(hex1);
            sb.append(hex2);
        }
        return sb.toString();
    }

    private static class BuilderImpl
    implements Builder {
        private String type;
        private String name;
        private String filename;
        private Charset charset;
        private Long size;

        public BuilderImpl(String type) {
            Assert.hasText((String)type, (String)"'type' must not be not empty");
            this.type = type;
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder filename(String filename) {
            this.filename = filename;
            return this;
        }

        @Override
        public Builder filename(String filename, Charset charset) {
            this.filename = filename;
            this.charset = charset;
            return this;
        }

        @Override
        public Builder size(Long size) {
            this.size = size;
            return this;
        }

        @Override
        public ContentDisposition build() {
            return new ContentDisposition(this.type, this.name, this.filename, this.charset, this.size);
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder filename(String var1);

        public Builder filename(String var1, Charset var2);

        public Builder size(Long var1);

        public ContentDisposition build();
    }
}

