/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AsyncClientHttpRequest;
import org.springframework.http.client.AsyncClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.OkHttpAsyncClientHttpRequest;
import org.springframework.http.client.OkHttpClientHttpRequest;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Deprecated
public class OkHttpClientHttpRequestFactory
implements ClientHttpRequestFactory,
AsyncClientHttpRequestFactory,
DisposableBean {
    private final OkHttpClient client;
    private final boolean defaultClient;

    public OkHttpClientHttpRequestFactory() {
        this.client = new OkHttpClient();
        this.defaultClient = true;
    }

    public OkHttpClientHttpRequestFactory(OkHttpClient client) {
        Assert.notNull((Object)client, (String)"OkHttpClient must not be null");
        this.client = client;
        this.defaultClient = false;
    }

    public void setReadTimeout(int readTimeout) {
        this.client.setReadTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
    }

    public void setWriteTimeout(int writeTimeout) {
        this.client.setWriteTimeout((long)writeTimeout, TimeUnit.MILLISECONDS);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.client.setConnectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public ClientHttpRequest createRequest(URI uri, HttpMethod httpMethod) {
        return new OkHttpClientHttpRequest(this.client, uri, httpMethod);
    }

    @Override
    public AsyncClientHttpRequest createAsyncRequest(URI uri, HttpMethod httpMethod) {
        return new OkHttpAsyncClientHttpRequest(this.client, uri, httpMethod);
    }

    public void destroy() throws IOException {
        if (this.defaultClient) {
            if (this.client.getCache() != null) {
                this.client.getCache().close();
            }
            this.client.getDispatcher().getExecutorService().shutdown();
        }
    }

    static Request buildRequest(HttpHeaders headers, byte[] content, URI uri, HttpMethod method) throws MalformedURLException {
        MediaType contentType = OkHttpClientHttpRequestFactory.getContentType(headers);
        RequestBody body = content.length > 0 || com.squareup.okhttp.internal.http.HttpMethod.requiresRequestBody((String)method.name()) ? RequestBody.create((MediaType)contentType, (byte[])content) : null;
        Request.Builder builder = new Request.Builder().url(uri.toURL()).method(method.name(), body);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String headerName = entry.getKey();
            for (String headerValue : entry.getValue()) {
                builder.addHeader(headerName, headerValue);
            }
        }
        return builder.build();
    }

    private static MediaType getContentType(HttpHeaders headers) {
        String rawContentType = headers.getFirst("Content-Type");
        return StringUtils.hasText((String)rawContentType) ? MediaType.parse((String)rawContentType) : null;
    }
}

