/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import com.fasterxml.jackson.annotation.JsonView;
import java.util.HashMap;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.AbstractEncoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpOutputMessage;
import org.springframework.http.codec.AbstractServerHttpMessageWriter;
import org.springframework.http.codec.EncoderHttpMessageWriter;
import org.springframework.http.codec.HttpMessageWriter;
import org.springframework.http.codec.json.AbstractJackson2Codec;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Mono;

public class Jackson2ServerHttpMessageWriter
extends AbstractServerHttpMessageWriter<Object> {
    public Jackson2ServerHttpMessageWriter(Encoder<Object> encoder) {
        super(new EncoderHttpMessageWriter<Object>(encoder));
    }

    public Jackson2ServerHttpMessageWriter(HttpMessageWriter<Object> writer) {
        super(writer);
    }

    @Override
    protected Map<String, Object> resolveWriteHints(ResolvableType streamType, ResolvableType elementType, MediaType mediaType, ServerHttpRequest request) {
        JsonView annotation;
        MethodParameter returnValue;
        HashMap<String, Object> hints = new HashMap<String, Object>();
        Object source = streamType.getSource();
        MethodParameter methodParameter = returnValue = source instanceof MethodParameter ? (MethodParameter)source : null;
        if (returnValue != null && (annotation = (JsonView)returnValue.getMethodAnnotation(JsonView.class)) != null) {
            Class[] classes = annotation.value();
            if (classes.length != 1) {
                throw new IllegalArgumentException("@JsonView only supported for write hints with exactly 1 class argument: " + returnValue);
            }
            hints.put(AbstractJackson2Codec.JSON_VIEW_HINT, classes[0]);
        }
        return hints;
    }

    @Override
    public Mono<Void> write(Publisher<?> inputStream, ResolvableType elementType, MediaType mediaType, ReactiveHttpOutputMessage outputMessage, Map<String, Object> hints) {
        if (mediaType != null && mediaType.isCompatibleWith(MediaType.APPLICATION_STREAM_JSON)) {
            HashMap<String, Object> hintsWithFlush = new HashMap<String, Object>(hints);
            hintsWithFlush.put(AbstractEncoder.FLUSHING_STRATEGY_HINT, AbstractEncoder.FlushingStrategy.AFTER_EACH_ELEMENT);
            return super.write(inputStream, elementType, mediaType, outputMessage, hintsWithFlush);
        }
        return super.write(inputStream, elementType, mediaType, outputMessage, hints);
    }

    @Override
    public Mono<Void> write(Publisher<?> inputStream, ResolvableType streamType, ResolvableType elementType, MediaType mediaType, ServerHttpRequest request, ServerHttpResponse response, Map<String, Object> hints) {
        if (mediaType != null && mediaType.isCompatibleWith(MediaType.APPLICATION_STREAM_JSON)) {
            HashMap<String, Object> hintsWithFlush = new HashMap<String, Object>(hints);
            hintsWithFlush.put(AbstractEncoder.FLUSHING_STRATEGY_HINT, AbstractEncoder.FlushingStrategy.AFTER_EACH_ELEMENT);
            return super.write(inputStream, streamType, elementType, mediaType, request, response, hintsWithFlush);
        }
        return super.write(inputStream, streamType, elementType, mediaType, request, response, hints);
    }
}

