/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.Encoder;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.codec.ServerSentEventHttpMessageWriter;
import org.springframework.http.codec.json.AbstractJackson2Codec;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Jackson2JsonEncoder
extends AbstractJackson2Codec
implements Encoder<Object> {
    private final PrettyPrinter ssePrettyPrinter;

    public Jackson2JsonEncoder() {
        this((ObjectMapper)Jackson2ObjectMapperBuilder.json().build());
    }

    public Jackson2JsonEncoder(ObjectMapper mapper) {
        super(mapper);
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentObjectsWith((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\ndata:"));
        this.ssePrettyPrinter = prettyPrinter;
    }

    public boolean canEncode(ResolvableType elementType, MimeType mimeType) {
        return this.mapper.canSerialize(elementType.getRawClass()) && (mimeType == null || JSON_MIME_TYPES.stream().anyMatch(m -> m.isCompatibleWith(mimeType)));
    }

    public List<MimeType> getEncodableMimeTypes() {
        return JSON_MIME_TYPES;
    }

    public Flux<DataBuffer> encode(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        Assert.notNull(inputStream, (String)"'inputStream' must not be null");
        Assert.notNull((Object)bufferFactory, (String)"'bufferFactory' must not be null");
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        if (inputStream instanceof Mono) {
            return Flux.from(inputStream).map(value -> this.encodeValue(value, bufferFactory, elementType, hints));
        }
        if (MediaType.APPLICATION_STREAM_JSON.isCompatibleWith(mimeType)) {
            return Flux.from(inputStream).map(value -> {
                DataBuffer buffer = this.encodeValue(value, bufferFactory, elementType, hints);
                buffer.write(new byte[]{10});
                return buffer;
            });
        }
        ResolvableType listType = ResolvableType.forClassWithGenerics(List.class, (ResolvableType[])new ResolvableType[]{elementType});
        return Flux.from(inputStream).collectList().map(list -> this.encodeValue(list, bufferFactory, listType, hints)).flux();
    }

    private DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType type, Map<String, Object> hints) {
        Class jsonView;
        TypeFactory typeFactory = this.mapper.getTypeFactory();
        JavaType javaType = typeFactory.constructType(type.getType());
        if (type.isInstance(value)) {
            javaType = this.getJavaType(type.getType(), null);
        }
        ObjectWriter writer = (jsonView = (Class)hints.get(AbstractJackson2Codec.JSON_VIEW_HINT)) != null ? this.mapper.writerWithView(jsonView) : this.mapper.writer();
        if (javaType != null && javaType.isContainerType()) {
            writer = writer.forType(javaType);
        }
        Boolean sse = (Boolean)hints.get(ServerSentEventHttpMessageWriter.SSE_CONTENT_HINT);
        SerializationConfig config = writer.getConfig();
        if (Boolean.TRUE.equals(sse) && config.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            writer = writer.with(this.ssePrettyPrinter);
        }
        DataBuffer buffer = bufferFactory.allocateBuffer();
        OutputStream outputStream = buffer.asOutputStream();
        try {
            writer.writeValue(outputStream, value);
        }
        catch (IOException ex) {
            throw new CodecException("Error while writing the data", (Throwable)ex);
        }
        return buffer;
    }
}

