/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server.reactive;

import java.io.IOException;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.server.reactive.HttpHandler;
import org.springframework.http.server.reactive.HttpHandlerAdapterSupport;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServletServerHttpRequest;
import org.springframework.http.server.reactive.ServletServerHttpResponse;
import org.springframework.util.Assert;

@WebServlet(asyncSupported=true)
public class ServletHttpHandlerAdapter
extends HttpHandlerAdapterSupport
implements Servlet {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private int bufferSize = 8192;
    private DataBufferFactory dataBufferFactory = new DefaultDataBufferFactory(false);

    public ServletHttpHandlerAdapter(HttpHandler httpHandler) {
        super(httpHandler);
    }

    public ServletHttpHandlerAdapter(Map<String, HttpHandler> handlerMap) {
        super(handlerMap);
    }

    public void setBufferSize(int bufferSize) {
        Assert.isTrue((bufferSize > 0 ? 1 : 0) != 0, (String)"Buffer size must be larger than zero");
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setDataBufferFactory(DataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)dataBufferFactory, (String)"DataBufferFactory must not be null");
        this.dataBufferFactory = dataBufferFactory;
    }

    public DataBufferFactory getDataBufferFactory() {
        return this.dataBufferFactory;
    }

    public void service(ServletRequest request, ServletResponse response) throws IOException {
        AsyncContext asyncContext = request.startAsync();
        ServerHttpRequest httpRequest = this.createRequest((HttpServletRequest)request, asyncContext);
        ServerHttpResponse httpResponse = this.createResponse((HttpServletResponse)response, asyncContext);
        HandlerResultSubscriber subscriber = new HandlerResultSubscriber(asyncContext);
        this.getHttpHandler().handle(httpRequest, httpResponse).subscribe((Subscriber)subscriber);
    }

    protected ServerHttpRequest createRequest(HttpServletRequest request, AsyncContext context) throws IOException {
        return new ServletServerHttpRequest(request, context, this.getDataBufferFactory(), this.getBufferSize());
    }

    protected ServerHttpResponse createResponse(HttpServletResponse response, AsyncContext context) throws IOException {
        return new ServletServerHttpResponse(response, context, this.getDataBufferFactory(), this.getBufferSize());
    }

    public void init(ServletConfig config) {
    }

    public ServletConfig getServletConfig() {
        return null;
    }

    public String getServletInfo() {
        return "";
    }

    public void destroy() {
    }

    private class HandlerResultSubscriber
    implements Subscriber<Void> {
        private final AsyncContext asyncContext;

        public HandlerResultSubscriber(AsyncContext asyncContext) {
            this.asyncContext = asyncContext;
        }

        public void onSubscribe(Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(Void aVoid) {
        }

        public void onError(Throwable ex) {
            ServletHttpHandlerAdapter.this.logger.error((Object)"Could not complete request", ex);
            HttpServletResponse response = (HttpServletResponse)this.asyncContext.getResponse();
            response.setStatus(500);
            this.asyncContext.complete();
        }

        public void onComplete() {
            ServletHttpHandlerAdapter.this.logger.debug((Object)"Successfully completed request");
            this.asyncContext.complete();
        }
    }
}

