/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util;

import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.util.PathMatcher;
import org.springframework.web.util.patterns.PathPattern;
import org.springframework.web.util.patterns.PathPatternParser;
import org.springframework.web.util.patterns.PatternComparatorConsideringPath;

public class ParsingPathMatcher
implements PathMatcher {
    private final ConcurrentMap<String, PathPattern> cache = new ConcurrentHashMap<String, PathPattern>(64);
    private final PathPatternParser parser = new PathPatternParser();

    public boolean match(String pattern, String path) {
        PathPattern p = this.getPathPattern(pattern);
        return p.matches(path);
    }

    public boolean matchStart(String pattern, String path) {
        PathPattern p = this.getPathPattern(pattern);
        return p.matchStart(path);
    }

    public String extractPathWithinPattern(String pattern, String path) {
        PathPattern p = this.getPathPattern(pattern);
        return p.extractPathWithinPattern(path);
    }

    public Map<String, String> extractUriTemplateVariables(String pattern, String path) {
        PathPattern p = this.getPathPattern(pattern);
        return p.matchAndExtract(path);
    }

    public String combine(String pattern1, String pattern2) {
        PathPattern pathPattern = this.getPathPattern(pattern1);
        return pathPattern.combine(pattern2);
    }

    public Comparator<String> getPatternComparator(String path) {
        return new PathPatternStringComparatorConsideringPath(path);
    }

    public boolean isPattern(String path) {
        return path.indexOf(42) != -1 || path.indexOf(63) != -1;
    }

    private PathPattern getPathPattern(String pattern) {
        PathPattern pathPattern = (PathPattern)this.cache.get(pattern);
        if (pathPattern == null) {
            pathPattern = this.parser.parse(pattern);
            this.cache.put(pattern, pathPattern);
        }
        return pathPattern;
    }

    class PathPatternStringComparatorConsideringPath
    implements Comparator<String> {
        private final PatternComparatorConsideringPath ppcp;

        public PathPatternStringComparatorConsideringPath(String path) {
            this.ppcp = new PatternComparatorConsideringPath(path);
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null) {
                return o2 == null ? 0 : 1;
            }
            if (o2 == null) {
                return -1;
            }
            PathPattern p1 = ParsingPathMatcher.this.getPathPattern(o1);
            PathPattern p2 = ParsingPathMatcher.this.getPathPattern(o2);
            return this.ppcp.compare(p1, p2);
        }
    }
}

