/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.util.patterns;

import java.text.MessageFormat;

public enum PatternMessage {
    MISSING_CLOSE_CAPTURE("Expected close capture character after variable name '}'"),
    MISSING_OPEN_CAPTURE("Missing preceeding open capture character before variable name'{'"),
    ILLEGAL_NESTED_CAPTURE("Not allowed to nest variable captures"),
    CANNOT_HAVE_ADJACENT_CAPTURES("Adjacent captures are not allowed"),
    ILLEGAL_CHARACTER_AT_START_OF_CAPTURE_DESCRIPTOR("Character ''{0}'' is not allowed at start of captured variable name"),
    ILLEGAL_CHARACTER_IN_CAPTURE_DESCRIPTOR("Character ''{0}'' is not allowed in a captured variable name"),
    NO_MORE_DATA_EXPECTED_AFTER_CAPTURE_THE_REST("No more pattern data allowed after '{*...}' pattern element"),
    BADLY_FORMED_CAPTURE_THE_REST("Expected form when capturing the rest of the path is simply '{*...}'"),
    MISSING_REGEX_CONSTRAINT("Missing regex constraint on capture"),
    ILLEGAL_DOUBLE_CAPTURE("Not allowed to capture ''{0}'' twice in the same pattern"),
    JDK_PATTERN_SYNTAX_EXCEPTION("Exception occurred in pattern compilation"),
    CAPTURE_ALL_IS_STANDALONE_CONSTRUCT("'{*...}' can only be preceeded by a path separator");

    private final String message;

    private PatternMessage(String message) {
        this.message = message;
    }

    public String formatMessage(Object ... inserts) {
        return MessageFormat.format(this.message, inserts);
    }
}

