/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec;

import java.time.Duration;
import org.springframework.lang.Nullable;

public class ServerSentEvent<T> {
    private final String id;
    private final String event;
    private final Duration retry;
    private final String comment;
    private final T data;

    private ServerSentEvent(String id, String event, Duration retry, String comment, T data) {
        this.id = id;
        this.event = event;
        this.retry = retry;
        this.comment = comment;
        this.data = data;
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public String event() {
        return this.event;
    }

    @Nullable
    public Duration retry() {
        return this.retry;
    }

    @Nullable
    public String comment() {
        return this.comment;
    }

    @Nullable
    public T data() {
        return this.data;
    }

    public String toString() {
        return "ServerSentEvent [id = '" + this.id + "', event='" + this.event + "', retry=" + this.retry + ", comment='" + this.comment + "', data=" + this.data + ']';
    }

    public static <T> Builder<T> builder() {
        return new BuilderImpl();
    }

    public static <T> Builder<T> builder(T data) {
        return new BuilderImpl<T>(data);
    }

    private static class BuilderImpl<T>
    implements Builder<T> {
        private String id;
        private String event;
        private Duration retry;
        private String comment;
        private T data;

        public BuilderImpl() {
        }

        public BuilderImpl(T data) {
            this.data = data;
        }

        @Override
        public Builder<T> id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder<T> event(String event) {
            this.event = event;
            return this;
        }

        @Override
        public Builder<T> retry(Duration retry) {
            this.retry = retry;
            return this;
        }

        @Override
        public Builder<T> comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder<T> data(T data) {
            this.data = data;
            return this;
        }

        @Override
        public ServerSentEvent<T> build() {
            return new ServerSentEvent(this.id, this.event, this.retry, this.comment, this.data);
        }
    }

    public static interface Builder<T> {
        public Builder<T> id(String var1);

        public Builder<T> event(String var1);

        public Builder<T> retry(Duration var1);

        public Builder<T> comment(String var1);

        public Builder<T> data(T var1);

        public ServerSentEvent<T> build();
    }
}

