/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.reactivestreams.Publisher;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.CodecException;
import org.springframework.core.codec.DecodingException;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.codec.HttpMessageDecoder;
import org.springframework.http.codec.json.Jackson2CodecSupport;
import org.springframework.http.codec.json.JsonObjectDecoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Jackson2JsonDecoder
extends Jackson2CodecSupport
implements HttpMessageDecoder<Object> {
    private final JsonObjectDecoder fluxDecoder = new JsonObjectDecoder(true);
    private final JsonObjectDecoder monoDecoder = new JsonObjectDecoder(false);

    public Jackson2JsonDecoder() {
        super((ObjectMapper)Jackson2ObjectMapperBuilder.json().build(), new MimeType[0]);
    }

    public Jackson2JsonDecoder(ObjectMapper mapper, MimeType ... mimeTypes) {
        super(mapper, mimeTypes);
    }

    public boolean canDecode(ResolvableType elementType, @Nullable MimeType mimeType) {
        JavaType javaType = this.objectMapper.getTypeFactory().constructType(elementType.getType());
        return !CharSequence.class.isAssignableFrom(elementType.resolve(Object.class)) && this.objectMapper.canDeserialize(javaType) && this.supportsMimeType(mimeType);
    }

    public List<MimeType> getDecodableMimeTypes() {
        return JSON_MIME_TYPES;
    }

    public Flux<Object> decode(Publisher<DataBuffer> input, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return this.decodeInternal(this.fluxDecoder, input, elementType, mimeType, hints);
    }

    public Mono<Object> decodeToMono(Publisher<DataBuffer> input, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return this.decodeInternal(this.monoDecoder, input, elementType, mimeType, hints).singleOrEmpty();
    }

    private Flux<Object> decodeInternal(JsonObjectDecoder objectDecoder, Publisher<DataBuffer> inputStream, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        Assert.notNull(inputStream, (String)"'inputStream' must not be null");
        Assert.notNull((Object)elementType, (String)"'elementType' must not be null");
        Class contextClass = this.getParameter(elementType).map(MethodParameter::getContainingClass).orElse(null);
        JavaType javaType = this.getJavaType(elementType.getType(), contextClass);
        Class jsonView = hints != null ? (Class)hints.get(Jackson2CodecSupport.JSON_VIEW_HINT) : null;
        ObjectReader reader = jsonView != null ? this.objectMapper.readerWithView(jsonView).forType(javaType) : this.objectMapper.readerFor(javaType);
        return objectDecoder.decode(inputStream, elementType, mimeType, hints).map(dataBuffer -> {
            try {
                Object value = reader.readValue(dataBuffer.asInputStream());
                DataBufferUtils.release((DataBuffer)dataBuffer);
                return value;
            }
            catch (InvalidDefinitionException ex) {
                throw new CodecException("Type definition error: " + ex.getType(), (Throwable)ex);
            }
            catch (JsonProcessingException ex) {
                throw new DecodingException("JSON decoding error: " + ex.getOriginalMessage(), (Throwable)ex);
            }
            catch (IOException ex) {
                throw new DecodingException("I/O error while parsing input stream", (Throwable)ex);
            }
        });
    }

    @Override
    public Map<String, Object> getDecodeHints(ResolvableType actualType, ResolvableType elementType, ServerHttpRequest request, ServerHttpResponse response) {
        return this.getHints(actualType);
    }

    @Override
    protected <A extends Annotation> A getAnnotation(MethodParameter parameter, Class<A> annotType) {
        return (A)parameter.getParameterAnnotation(annotType);
    }
}

